@extends('layouts.app')
@section('title','Edit Permission')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111;--primary:#1d4ed8}
  .wrap{max-width:800px;margin:0 auto}
  .card{background:var(--card);border:1px solid var(--border);border-radius:10px}
  .card-header{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
  .card-body{padding:16px}
  .title{font-size:18px;font-weight:800}
  .muted{color:var(--muted)}
  .row{display:grid;grid-template-columns:1fr;gap:12px}
  .input, .select, textarea{width:100%;border:1px solid var(--border);border-radius:8px;padding:10px 12px}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:var(--primary);color:#fff}
  .btn-ghost{background:#f3f4f6}
  .errors{background:#fff7f7;border:1px solid #fecaca;color:#b91c1c;padding:10px;border-radius:8px;margin-bottom:12px}
  small.helper{color:var(--muted)}
</style>
@endpush

@section('content')
<div class="wrap">
  <div class="card">
    <div class="card-header">
      <div class="title"><i class="fa-regular fa-pen-to-square"></i> Edit Permission</div>
      <div>
        <a href="{{ route('permissions.index') }}" class="btn btn-ghost"><i class="fa-solid fa-arrow-left"></i> Back</a>
      </div>
    </div>

    <div class="card-body">
      @if ($errors->any())
        <div class="errors">
          <ul style="margin:0;padding-left:18px">
            @foreach ($errors->all() as $err)
              <li>{{ $err }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <form method="POST" action="{{ route('permissions.update',$permission->id) }}">
        @csrf @method('PUT')

        <div class="row">
          <div>
            <label for="name" class="muted">Permission Name</label>
            <input id="name" name="name" class="input" value="{{ old('name',$permission->name) }}" required>
            <small class="helper">Dot notation সাজেস্টেড (যেমন <code>users.update</code>).</small>
          </div>

          <div>
            <label for="guard_name" class="muted">Guard</label>
            <select id="guard_name" name="guard_name" class="select">
              @php $guardOld = old('guard_name',$permission->guard_name ?? 'web'); @endphp
              <option value="web" {{ $guardOld==='web'?'selected':'' }}>web</option>
              <option value="api" {{ $guardOld==='api'?'selected':'' }}>api</option>
            </select>
          </div>

          <div>
            <button class="btn btn-primary" type="submit">
              <i class="fa-solid fa-floppy-disk"></i> Update
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>
</div>
@endsection
