@extends('layouts.app')
@section('title','Add Permission')

@push('styles')
<style>
  :root{--card:#fff;--border:#e5e7eb;--muted:#6b7280;--text:#111;--primary:#1d4ed8}
  .wrap{max-width:860px;margin:0 auto}
  .card{background:var(--card);border:1px solid var(--border);border-radius:12px}
  .card-header{display:flex;align-items:center;justify-content:space-between;padding:14px 16px;border-bottom:1px solid var(--border)}
  .card-body{padding:16px}
  .title{font-size:18px;font-weight:800}
  .muted{color:var(--muted)}
  .grid{display:grid;gap:12px}
  .cols-2{grid-template-columns:1fr 1fr}
  .input, .select, textarea{width:100%;border:1px solid var(--border);border-radius:8px;padding:10px 12px}
  .btn{display:inline-flex;align-items:center;gap:8px;border:0;border-radius:8px;padding:10px 14px;font-weight:700;cursor:pointer}
  .btn-primary{background:var(--primary);color:#fff}
  .btn-ghost{background:#f3f4f6}
  .errors{background:#fff7f7;border:1px solid #fecaca;color:#b91c1c;padding:10px;border-radius:8px;margin-bottom:12px}
  small.helper{color:var(--muted)}
  .hint{font-size:12px;color:var(--muted)}
  .box{border:1px dashed var(--border);border-radius:10px;padding:12px}
</style>
@endpush

@section('content')
<div class="wrap">
  <div class="card">
    <div class="card-header">
      <div class="title"><i class="fa-solid fa-circle-plus"></i> Add Permission</div>
      <a href="{{ route('permissions.index') }}" class="btn btn-ghost">
        <i class="fa-solid fa-arrow-left"></i> Back
      </a>
    </div>

    <div class="card-body">
      @if ($errors->any())
        <div class="errors">
          <ul style="margin:0;padding-left:18px">
            @foreach ($errors->all() as $err)
              <li>{{ $err }}</li>
            @endforeach
          </ul>
        </div>
      @endif

      <form method="POST" action="{{ route('permissions.store') }}">
        @csrf

        {{-- Single permission --}}
        <div class="grid">
          <div>
            <label class="muted">Permission Name</label>
            <input name="name" class="input" value="{{ old('name') }}" placeholder="e.g. groups.view" required>
            <div class="hint">ডট নোটেশন ভাল: <b>module.action</b> (যেমন <code>groups.view</code>)</div>
          </div>

          <div>
            <label class="muted">Custom Slug (optional)</label>
            <input name="slug" class="input" value="{{ old('slug') }}" placeholder="auto if empty">
          </div>

          <div class="grid cols-2">
            <div>
              <label class="muted">Parent</label>
              <select name="parent_permission_id" class="select">
                <option value="0">Root / No Parent</option>
                @foreach ($parents as $p)
                  <option value="{{ $p->id }}" {{ old('parent_permission_id')==$p->id?'selected':'' }}>
                    {{ $p->name }} ({{ $p->slug }})
                  </option>
                @endforeach
              </select>
              <div class="hint">তোমার DB-তে parent_permission_id NOT NULL; root হলে 0 পাঠানো হবে।</div>
            </div>

            <div>
              <label class="muted">Position</label>
              <input type="number" name="position" class="input" value="{{ old('position', 999) }}">
            </div>
          </div>

          <div class="grid cols-2">
            <div>
              <label class="muted">Status</label>
              <select name="status" class="select">
                <option value="1" {{ old('status',1)==1?'selected':'' }}>Active</option>
                <option value="0" {{ old('status',1)==0?'selected':'' }}>Inactive</option>
              </select>
            </div>
            <div>
              <label class="muted">Description</label>
              <input name="description" class="input" value="{{ old('description') }}">
            </div>
          </div>
        </div>

        <br>

        {{-- Scaffold (optional) --}}
        <div class="box">
          <label style="display:flex;align-items:center;gap:8px;margin-bottom:8px;">
            <input type="checkbox" name="scaffold" id="scaffold" value="1" {{ old('scaffold')?'checked':'' }}>
            <b>Create Module (Scaffold)</b>
          </label>

          <div id="scaffoldFields" style="display:none" class="grid cols-2">
            <div>
              <label class="muted">Module Key</label>
              <input name="module" class="input" value="{{ old('module') }}" placeholder="e.g. groups">
              <small class="helper">এটা দিয়ে <code>groups.index/view/create...</code> তৈরি হবে</small>
            </div>
            <div>
              <label class="muted">Module Label (Parent name)</label>
              <input name="label" class="input" value="{{ old('label') }}" placeholder="e.g. Group">
            </div>

            <div style="grid-column: 1 / span 2;">
              <label class="muted">Actions</label><br>
              @php $acts = old('actions', ['view','create','edit','delete']); @endphp
              @foreach (['view','create','edit','delete'] as $a)
                <label style="margin-right:12px;">
                  <input type="checkbox" name="actions[]" value="{{ $a }}" {{ in_array($a, (array)$acts) ? 'checked' : '' }}>
                  {{ ucfirst($a) }}
                </label>
              @endforeach
            </div>
          </div>
        </div>

        <br>
        <button class="btn btn-primary" type="submit">
          <i class="fa-solid fa-floppy-disk"></i> Save
        </button>
      </form>
    </div>
  </div>
</div>

@push('scripts')
<script>
  const cb = document.getElementById('scaffold');
  const sec = document.getElementById('scaffoldFields');
  function toggleScaffold(){ sec.style.display = cb.checked ? 'grid' : 'none'; }
  toggleScaffold();
  cb.addEventListener('change', toggleScaffold);
</script>
@endpush
@endsection
