﻿{{-- resources/views/party/party_types/index.blade.php --}}
@extends('layouts.app')
@section('title','Party Type List')

@section('content')
@php
  // route name variations (আপনার রাউট না বদলেই কাজ করবে)
  $indexRoute   = collect(['party.party-types.index','party.party_types.index','party-types.index','party_types.index'])->first(fn($n)=>Route::has($n));
  $createRoute  = collect(['party.party-types.create','party.party_types.create','party-types.create','party_types.create'])->first(fn($n)=>Route::has($n));
  $editRoute    = collect(['party.party-types.edit','party.party_types.edit','party-types.edit','party_types.edit'])->first(fn($n)=>Route::has($n));
  $destroyRoute = collect(['party.party-types.destroy','party.party_types.destroy','party-types.destroy','party_types.destroy'])->first(fn($n)=>Route::has($n));
  $partyTypes   = $partyTypes ?? collect();
@endphp

<div class="ptl-wrap">
  {{-- Title + Add (same row; Add ডানদিকে) --}}
  <div class="ptl-titlebar">
    <div class="ptl-title">
      <span class="ptl-listicon" aria-hidden="true"><span></span><span></span><span></span></span>
      <span class="ptl-titletext">Party Type List</span>
    </div>
    @if($createRoute)
      <a class="ptl-addbtn" href="{{ route($createRoute) }}">+ Add Party Type</a>
    @endif
  </div>

  {{-- Card (table + pager) --}}
  <div class="ptl-card">
    {{-- Search right side --}}
    <div class="ptl-headbar">
      <div></div>
      <form action="{{ $indexRoute ? route($indexRoute) : url()->current() }}" method="GET" class="ptl-search">
        <label>Search:</label>
        <input type="text" name="q" value="{{ request('q') }}">
      </form>
    </div>

    <div class="ptl-tablewrap">
      <table class="ptl-table">
        <colgroup>
          <col style="width: 70px;" />                  {{-- SL --}}
          <col class="col-party" />                     {{-- Party Type (auto/flex) --}}
          <col style="width: 120px;" />                 {{-- Status --}}
          <col style="width: 160px;" />                 {{-- Action --}}
        </colgroup>
        <thead>
          <tr>
            <th class="br">SL</th>
            <th class="br">Party Type</th>
            <th class="br">Status</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
        @forelse($partyTypes as $pt)
          @php $sl = method_exists($partyTypes,'firstItem') ? $partyTypes->firstItem() + $loop->index : $loop->iteration; @endphp
          <tr>
            <td class="br">{{ $sl }}</td>
            <td class="br">{{ $pt->name }}</td>
            <td class="br">
              @if(($pt->status ?? $pt->is_active ?? 1) == 1)
                <span class="ptl-badge ptl-badge-green">Active</span>
              @else
                <span class="ptl-badge ptl-badge-gray">Inactive</span>
              @endif
            </td>
            <td>
              <div class="ptl-actions">
                <button type="button" class="ptl-btn ptl-btn-info" title="Info" disabled>{!! ptl_svg('info') !!}</button>
                @if($editRoute)
                  <a class="ptl-btn ptl-btn-edit" title="Edit" href="{{ route($editRoute, $pt->id) }}">{!! ptl_svg('edit') !!}</a>
                @endif
                @if($destroyRoute)
                  <form action="{{ route($destroyRoute, $pt->id) }}" method="POST" onsubmit="return confirm('Delete this party type?')" style="display:inline">
                    @csrf @method('DELETE')
                    <button type="submit" class="ptl-btn ptl-btn-del" title="Delete">{!! ptl_svg('trash') !!}</button>
                  </form>
                @endif
              </div>
            </td>
          </tr>
        @empty
          <tr><td colspan="4" class="ptl-empty">No data found.</td></tr>
        @endforelse
        </tbody>
      </table>
    </div>

    <div class="ptl-footer">
      <div class="ptl-pager">
        @if(method_exists($partyTypes,'links'))
          @if($partyTypes->onFirstPage())
            <span class="ptl-page ptl-disabled">Previous</span>
          @else
            <a class="ptl-page" href="{{ $partyTypes->previousPageUrl() }}">Previous</a>
          @endif
          <span class="ptl-page ptl-current">{{ $partyTypes->currentPage() }}</span>
          @if($partyTypes->hasMorePages())
            <a class="ptl-page" href="{{ $partyTypes->nextPageUrl() }}">Next</a>
          @else
            <span class="ptl-page ptl-disabled">Next</span>
          @endif
        @endif
      </div>
    </div>
  </div>
</div>

{{-- inline SVGs --}}
@php
  function ptl_svg($name){
    $svgs = [
      'info' => '<svg viewBox="0 0 24 24" width="14" height="14"><path fill="#fff" d="M12 2a10 10 0 1 0 0 20 10 10 0 0 0 0-20zm1 15h-2v-6h2v6zm0-8h-2V7h2v2z"/></svg>',
      'edit' => '<svg viewBox="0 0 24 24" width="14" height="14"><path fill="#fff" d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1 1 0 0 0 0-1.41L18.37 3.3a1 1 0 0 0-1.41 0L15.13 5.1l3.75 3.75 1.83-1.81z"/></svg>',
      'trash'=> '<svg viewBox="0 0 24 24" width="14" height="14"><path fill="#fff" d="M6 7h12v2H6V7zm2 3h8l-1 10H9L8 10zm3-6h2l1 1h4v2H6V5h4l1-1z"/></svg>',
    ];
    return $svgs[$name] ?? '';
  }
@endphp

<style>
  :root{
    --blue:#1e66b0;
    --thead-top:#f4f8ff; --thead-bot:#e9eef7;
    --border:#dbe7f3; --row:#e7edf5; --foot:#f3f7fc;
    --btn-blue:#2ea8ff; --btn-blue-b:#1d8fe6;
    --btn-info:#5bbcf2; --btn-info-b:#3aa5df;
    --btn-green:#28a745; --btn-red:#dc3545;
    --badge-green:#5fd05b; --badge-gray:#aeb8c2;
  }
  .ptl-wrap{font-family:"Segoe UI",Arial,Helvetica,sans-serif;color:#1b2b45}

  .ptl-titlebar{display:flex;align-items:center;justify-content:space-between;margin:10px 0 8px;border-bottom:1px solid #e7edf5;padding-bottom:6px}
  .ptl-title{display:flex;align-items:center;gap:8px}
  .ptl-listicon{display:inline-flex;flex-direction:column;gap:4px}
  .ptl-listicon span{width:18px;height:3px;background:var(--blue);border-radius:2px;display:block}
  .ptl-titletext{font-size:26px;font-weight:800;color:var(--blue)}
  .ptl-addbtn{background:var(--btn-blue);border:1px solid var(--btn-blue-b);color:#fff;text-decoration:none;padding:6px 12px;border-radius:3px;font-weight:700}
  .ptl-addbtn:hover{filter:brightness(.98)}

  .ptl-card{border:1px solid var(--border);border-radius:6px;background:#fff;overflow:hidden}
  .ptl-headbar{display:flex;justify-content:space-between;align-items:center;padding:8px 12px;background:linear-gradient(var(--thead-top),var(--thead-bot));border-bottom:1px solid var(--border)}
  .ptl-search{display:flex;align-items:center;gap:8px}
  .ptl-search label{color:#2b4a6b}
  .ptl-search input{height:28px;border:1px solid #cfd9e6;border-radius:3px;padding:0 6px;min-width:240px;outline:none}
  .ptl-search input:focus{border-color:#9fc2ea;box-shadow:0 0 0 2px rgba(47,143,230,.12)}

  /* ========= Table exact sizing & borders (red marks fixed) ========= */
  .ptl-table{width:100%;border-collapse:separate;border-spacing:0}
  .ptl-table thead th{
    padding:10px 12px;text-align:left;color:#2460a3;font-weight:800;
    background:linear-gradient(var(--thead-top),var(--thead-bot));
    border-bottom:1px solid var(--border);
    height:42px;                    /* হেডার হাইট স্টেবল */
  }
  .ptl-table thead th.br{border-right:1px solid var(--border)}
  .ptl-table tbody td{
    padding:12px;border-bottom:1px solid var(--row);
    font-size:14px;vertical-align:middle;background:#fff;height:56px; /* রো হাইট স্টেবল */
  }
  .ptl-table tbody td.br{border-right:1px solid var(--border)}
  .ptl-table tbody tr:last-child td{border-bottom:0}
  /* Party Type কলাম auto, Status=120px, Action=160px উপরে colgroup-এ সেট আছে */

  .ptl-empty{padding:24px;text-align:center;color:#64748b;background:#fff}

  .ptl-badge{display:inline-block;padding:4px 10px;border-radius:3px;font-size:12px;font-weight:700;color:#fff}
  .ptl-badge-green{background:var(--badge-green)}
  .ptl-badge-gray{background:var(--badge-gray)}

  .ptl-actions{display:flex;gap:8px;align-items:center}
  .ptl-btn{width:30px;height:28px;border-radius:3px;border:1px solid transparent;display:inline-flex;align-items:center;justify-content:center;text-decoration:none;cursor:pointer}
  .ptl-btn-info{background:var(--btn-info);border-color:var(--btn-info-b)}
  .ptl-btn-edit{background:var(--btn-green)}
  .ptl-btn-del{background:var(--btn-red)}
  .ptl-btn:hover{filter:brightness(.97)}
  .ptl-btn[disabled]{opacity:.9;cursor:default}

  .ptl-footer{display:flex;justify-content:flex-end;align-items:center;padding:10px 12px;border-top:1px solid var(--border);background:var(--foot)}
  .ptl-pager{display:flex;gap:8px}
  .ptl-page{display:inline-block;padding:6px 10px;border:1px solid #cfd9e6;border-radius:3px;background:#fff;color:#2b4a6b;text-decoration:none;font-weight:800}
  .ptl-current{background:#2f8fe6;border-color:#257fce;color:#fff}
  .ptl-disabled{opacity:.6;pointer-events:none}
</style>
@endsection

