{{-- resources/views/party_types/edit.blade.php --}}
@extends('layouts.app')
@section('title','Edit Party Type')

@section('content')
@php
  // Flexible route resolution (so you don't have to change your routes)
  $indexRoute  = collect(['party_types.index','party-types.index','party.party_types.index','party.party-types.index'])->first(fn($n)=>Route::has($n));
  $updateRoute = collect(['party_types.update','party-types.update','party.party_types.update','party.party-types.update'])->first(fn($n)=>Route::has($n));
@endphp

<div class="pt-edit-wrap">
  <!-- Header -->
  <div class="pt-edit-head">
    <div class="pt-edit-title">
      <span class="ico-gear" aria-hidden="true"></span>
      <span>Edit Party Type</span>
    </div>
    @if($indexRoute)
      <a href="{{ route($indexRoute) }}" class="pt-link">
        <span class="ico-list" aria-hidden="true"></span>
        Party Type List
      </a>
    @endif
  </div>

  <!-- Card -->
  <div class="pt-edit-card">
    <form method="POST" action="{{ route($updateRoute, $partyType->id) }}">
      @csrf
      @method('PUT')

      {{-- Party Type --}}
      <div class="pt-row">
        <div class="pt-label">Party Type</div>
        <div class="pt-field">
          <input type="text" name="name" value="{{ old('name', $partyType->name) }}" class="pt-input" placeholder="Party type name">
          @error('name') <div class="pt-error">{{ $message }}</div> @enderror
        </div>
      </div>

      {{-- Status --}}
      <div class="pt-row">
        <div class="pt-label">Status</div>
        <div class="pt-field">
          <select name="status" class="pt-select">
            <option value="1" {{ old('status', (int)($partyType->status ?? $partyType->is_active ?? 1))===1 ? 'selected':'' }}>Active</option>
            <option value="0" {{ old('status', (int)($partyType->status ?? $partyType->is_active ?? 1))===0 ? 'selected':'' }}>Inactive</option>
          </select>
          @error('status') <div class="pt-error">{{ $message }}</div> @enderror
        </div>
      </div>

      {{-- Footer buttons --}}
      <div class="pt-actions">
        <button type="submit" class="btn btn-green">
          <span class="ico-check" aria-hidden="true"></span> Update
        </button>
        <button type="reset" class="btn btn-gray">
          <span class="ico-refresh" aria-hidden="true"></span> Reset
        </button>
      </div>
    </form>
  </div>
</div>

<style>
  :root{
    --border:#dfe5ec;
    --head-top:#f6f7f9; --head-bot:#eceff3;
    --label-bg:#e9edf2; --label-text:#334155;
    --input-b:#cfd9e6;
    --btn-green:#79b986; --btn-green-b:#66a875;
    --btn-gray:#a9b4c1;  --btn-gray-b:#8f9aac;
    --link-blue:#2a6fb1;
    --txt:#1b2b45;
  }
  .pt-edit-wrap{font-family:"Segoe UI",Arial,Helvetica,sans-serif;color:var(--txt)}
  .pt-edit-head{
    display:flex;justify-content:space-between;align-items:center;
    padding:10px 12px;border:1px solid var(--border);
    background:linear-gradient(var(--head-top),var(--head-bot));
    border-radius:3px 3px 0 0;
  }
  .pt-edit-title{display:flex;align-items:center;gap:8px;font-size:20px;font-weight:700;color:#2e6faf}
  .pt-link{display:inline-flex;align-items:center;gap:6px;text-decoration:none;color:#2e6faf;font-weight:600;border:1px solid var(--border);padding:6px 10px;border-radius:3px;background:#f7f9fc}
  .pt-link:hover{filter:brightness(.98)}

  .ico-gear, .ico-list, .ico-check, .ico-refresh{
    display:inline-block;width:16px;height:16px;background-size:16px 16px;background-repeat:no-repeat
  }
  .ico-gear{background-image:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="%232e6faf" d="M19.14,12.94a7.43,7.43,0,0,0,.05-.94,7.43,7.43,0,0,0-.05-.94l2.11-1.65a.48.48,0,0,0,.11-.61l-2-3.46a.49.49,0,0,0-.6-.22l-2.49,1a7.42,7.42,0,0,0-1.62-.94l-.38-2.65A.49.49,0,0,0,13,.5H11a.49.49,0,0,0-.49.41L10.1,3.56a7.42,7.42,0,0,0-1.62.94l-2.49-1a.49.49,0,0,0-.6.22l-2,3.46a.48.48,0,0,0,.11.61L3.71,11.06a7.43,7.43,0,0,0-.05.94,7.43,7.43,0,0,0,.05.94L1.6,14.59a.48.48,0,0,0-.11.61l2,3.46a.49.49,0,0,0,.6.22l2.49-1a7.42,7.42,0,0,0,1.62.94l.38,2.65A.49.49,0,0,0,11,23.5h2a.49.49,0,0,0,.49-.41l.38-2.65a7.42,7.42,0,0,0,1.62-.94l2.49,1a.49.49,0,0,0,.6-.22l2-3.46a.48.48,0,0,0-.11-.61ZM12,15.5A3.5,3.5,0,1,1,15.5,12,3.5,3.5,0,0,1,12,15.5Z"/></svg>')}
  .ico-list{background-image:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="%232e6faf" d="M4 6h16v2H4zm0 5h16v2H4zm0 5h16v2H4z"/></svg>')}
  .ico-check{background-image:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="white" d="M20.285 2.857L9 14.143l-5.285-5.286-2.143 2.143L9 18.429 22.428 5z"/></svg>')}
  .ico-refresh{background-image:url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24"><path fill="white" d="M12 6V3L8 7l4 4V8c2.757 0 5 2.243 5 5a5 5 0 11-5-5z"/></svg>')}

  .pt-edit-card{border:1px solid var(--border);border-top:0;border-radius:0 0 3px 3px;background:#fff;padding:22px}
  .pt-row{display:flex;align-items:center;margin-bottom:18px}
  .pt-label{
    width:180px;background:var(--label-bg);color:var(--label-text);
    border:1px solid var(--border);border-right:0;border-radius:3px 0 0 3px;
    padding:10px 14px;font-weight:600;
  }
  .pt-field{flex:1}
  .pt-input, .pt-select{
    width:100%;height:36px;border:1px solid var(--input-b);border-radius:0 3px 3px 0;
    padding:6px 10px;outline:none;background:#fff;
  }
  .pt-input:focus, .pt-select:focus{border-color:#9fc2ea;box-shadow:0 0 0 2px rgba(47,143,230,.12)}
  .pt-error{color:#b91c1c;font-size:12px;margin-top:6px}

  .pt-actions{margin-top:22px;display:flex;gap:10px}
  .btn{
    display:inline-flex;align-items:center;gap:8px;border-radius:3px;border:1px solid transparent;
    padding:9px 14px;font-weight:700;text-decoration:none;cursor:pointer
  }
  .btn.btn-green{background:var(--btn-green);border-color:var(--btn-green-b);color:#fff}
  .btn.btn-gray{background:var(--btn-gray);border-color:var(--btn-gray-b);color:#fff}
  .btn:hover{filter:brightness(.97)}
</style>
@endsection
