﻿{{-- resources/views/party/party_types/create.blade.php --}}
@extends('layouts.app')
@section('title','Add New Party Type')

@push('styles')
<style>
  :root{ --border:#e5e7eb; }

  .form-card{background:#fff;border:1px solid var(--border);border-radius:10px;overflow:hidden}
  .form-card .head{
    display:flex;align-items:center;justify-content:space-between;
    padding:12px 14px;border-bottom:1px solid var(--border);
    background:linear-gradient(#f8fafc,#eef2f7)
  }
  .form-card .head h3{margin:0;font-size:18px;font-weight:600;color:#0f172a;display:flex;gap:8px;align-items:center}

  .btn-soft{
    display:inline-flex;align-items:center;gap:8px;padding:8px 12px;border-radius:8px;
    border:1px solid #d1d5db;background:#f8fafc;color:#0f172a;text-decoration:none;font-weight:500
  }
  .btn-soft:hover{background:#eef2f7}

  .body{padding:16px}

  .form-row{display:grid;grid-template-columns:220px 1fr;gap:10px;margin-bottom:12px}
  .form-label{
    background:#f1f5f9;border:1px solid var(--border);border-radius:8px;
    display:flex;align-items:center;padding:10px 12px;font-weight:500;color:#374151
  }
  .req{color:#ef4444;margin-left:4px;font-weight:600}

  .form-control,.form-select{
    width:100%;padding:10px 12px;border:1px solid var(--border);border-radius:8px;background:#fff;
    font-weight:400;font-size:14px
  }
  .form-control::placeholder{color:#9ca3af}

  .error-text{color:#dc2626;font-size:12.5px;margin-top:6px}

  .flash{
    margin-bottom:12px;padding:10px 12px;border-radius:8px;
    border:1px solid #d1fae5;background:#ecfdf5;color:#065f46
  }

  .actions{
    display:flex;gap:10px;justify-content:flex-end;margin-top:14px
  }
  .btn-primary{
    background:#2563eb;border:1px solid #1e40af;color:#fff;border-radius:8px;
    padding:10px 14px;font-weight:600;display:inline-flex;align-items:center;gap:8px
  }
  .btn-secondary{
    background:#94a3b8;border:1px solid #64748b;color:#fff;border-radius:8px;
    padding:10px 14px;font-weight:500;display:inline-flex;align-items:center;gap:8px
  }
</style>
@endpush

@section('content')
@php
  // Detect list + store route names (works with or without "party." prefix / hyphen vs underscore)
  $indexRoute = collect([
      'party.party-types.index','party.party_types.index',
      'party-types.index','party_types.index'
  ])->first(fn($n)=>Route::has($n));

  $storeRoute = collect([
      'party.party-types.store','party.party_types.store',
      'party-types.store','party_types.store'
  ])->first(fn($n)=>Route::has($n));
@endphp

<div class="form-card">
  <div class="head">
    <h3><i class="fa-solid fa-gear"></i> Add New Party Type</h3>
    <a href="{{ $indexRoute ? route($indexRoute) : url()->previous() }}" class="btn-soft">
      <i class="fa-solid fa-table"></i> Party Type List
    </a>
  </div>

  <div class="body">
    @if(session('success'))
      <div class="flash">
        <i class="fa-solid fa-check-circle"></i> {{ session('success') }}
      </div>
    @endif

    @if ($errors->any())
      <div class="flash" style="border-color:#fee2e2;background:#fef2f2;color:#991b1b">
        <strong>Whoops!</strong> Please fix the errors below.
      </div>
    @endif

    {{-- IMPORTANT: Post to the STORE route (not create) --}}
    @if($storeRoute)
      <form action="{{ route($storeRoute) }}" method="POST" autocomplete="off">
        @csrf

        <div class="form-row">
          <label class="form-label" for="name">
            Party Type <span class="req">*</span>
          </label>
          <div>
            <input
              type="text"
              id="name"
              name="name"
              class="form-control"
              placeholder="Enter the party type name"
              value="{{ old('name') }}"
              required
            >
            @error('name') <div class="error-text">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="form-row">
          <label class="form-label" for="status">Status</label>
          <div>
            <select id="status" name="status" class="form-select">
              <option value="1" {{ old('status','1')=='1' ? 'selected' : '' }}>Active</option>
              <option value="0" {{ old('status')==='0' ? 'selected' : '' }}>Inactive</option>
            </select>
            @error('status') <div class="error-text">{{ $message }}</div> @enderror
          </div>
        </div>

        <div class="actions">
          <button type="submit" class="btn-primary">
            <i class="fa-solid fa-floppy-disk"></i> Save
          </button>
          <button type="reset" class="btn-secondary">
            <i class="fa-solid fa-rotate"></i> Reset
          </button>
        </div>
      </form>
    @else
      <div class="flash" style="border-color:#fde68a;background:#fffbeb;color:#92400e">
        <strong>Heads up:</strong> No <code>*.store</code> route found. Add one of these to <code>routes/web.php</code>:
        <ul style="margin:6px 0 0 18px">
          <li><code>Route::post('/party-types', [PartyTypesController::class,'store'])->name('party_types.store');</code></li>
          <li>or <code>Route::post('/party/party-types', [PartyTypesController::class,'store'])->name('party.party_types.store');</code></li>
          <li>or the hyphen versions: <code>party.party-types.store</code> / <code>party-types.store</code></li>
        </ul>
      </div>
    @endif
  </div>
</div>
@endsection

