@extends('layouts.app')
@section('title','Upload Customers')

@push('styles')
<style>
  .content-header .page-tools{float:right; margin-top:-28px}
  .dropbox{
    border:1px dashed #cbd5e1; border-radius:6px; background:#fff;
    min-height:140px; display:flex; align-items:center; justify-content:center;
    color:#94a3b8; position:relative
  }
  .dropbox:hover{background:#f8fafc}
  .dropbox input[type=file]{position:absolute; inset:0; opacity:0; cursor:pointer}
  .form-actions{text-align:right}
</style>
@endpush

@section('content')
<div class="content-wrapper">
  <section class="content-header">
    <h1><i class="fa fa-list"></i> Upload Customers</h1>
    <div class="page-tools">
      <a class="btn btn-success btn-sm" href="{{ route('party.customers.csv') }}">
        <i class="fa fa-list"></i> List Customer CSV
      </a>
      <a class="btn btn-primary btn-sm" href="{{ route('party.customers.csv.sample') }}">
        <i class="fa fa-download"></i> Download Sample
      </a>
    </div>
  </section>

  <section class="content">
    <div class="box">
      <div class="box-body">
        @if ($errors->any())
          <div class="alert alert-danger">
            <ul style="margin:0">@foreach ($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
          </div>
        @endif

        <form action="{{ route('party.customers.csv.upload.store') }}" method="post" enctype="multipart/form-data">
          @csrf
          <div class="form-group row">
            <label class="col-sm-2 control-label"><b>Upload CSV file</b></label>
            <div class="col-sm-10">
              <div class="dropbox">
                <div>
                  <div style="font-weight:700">Drop files here or click to choose</div>
                  <div style="font-size:28px; opacity:.5; margin-top:6px"><i class="fa fa-cloud-upload"></i></div>
                  <div id="fileName" style="font-size:12px; margin-top:6px"></div>
                </div>
                <input type="file" name="csv_file" id="csv_file" accept=".csv,text/csv" required>
              </div>
            </div>
          </div>

          <div class="form-actions">
            <button class="btn btn-primary"><i class="fa fa-save"></i> Save Customers</button>
          </div>
        </form>
      </div>
    </div>
  </section>
</div>
@endsection

@push('scripts')
<script>
  const fileInput = document.getElementById('csv_file');
  const nameBox   = document.getElementById('fileName');
  if (fileInput) {
    fileInput.addEventListener('change', function(){
      nameBox.textContent = this.files.length ? this.files[0].name : '';
    });
  }
</script>
@endpush
