@extends('layouts.app')
@section('title','CSV Customer List')

@push('styles')
<style>
  .content-header .page-tools{float:right; margin-top:-28px}
  .table>thead>tr>th{
    background:#eaf1ff; font-weight:700; white-space:nowrap
  }
  .table td{white-space:nowrap}
  .actions{display:inline-flex; gap:6px}
  .text-right-num{text-align:right}
</style>
@endpush

@section('content')
<div class="content-wrapper">
  <section class="content-header">
    <h1><i class="fa fa-list"></i> CSV Customer List</h1>
    <div class="page-tools">
      <a class="btn btn-info btn-sm" href="{{ route('party.customers.csv.upload') }}">
        <i class="fa fa-upload"></i> Upload CSV
      </a>
    </div>
  </section>

  <section class="content">
    @if(session('success'))
      <div class="alert alert-success"><strong>Success !</strong> {{ session('success') }}</div>
    @endif

    <div class="box">
      <div class="box-header with-border" style="display:flex;justify-content:space-between;align-items:center">
        <form action="{{ route('party.customers.csv.import50') }}" method="POST" style="margin:0">
          @csrf
          <button class="btn btn-primary"><i class="fa fa-check-circle"></i> Import First 50 Customer</button>
        </form>
        <form action="{{ route('party.customers.csv.deleteAll') }}" method="POST" onsubmit="return confirm('Delete ALL rows?')" style="margin:0">
          @csrf @method('DELETE')
          <button class="btn btn-danger"><i class="fa fa-trash"></i> Delete All</button>
        </form>
      </div>

      <div class="box-body">
        <div class="table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
            <tr>
              <th>SL.</th>
              <th>Customer Name</th>
              <th>Company Name</th>
              <th>Email</th>
              <th>Address</th>
              <th>Phone Personal</th>
              <th>Executive</th>
              <th>Area</th>
              <th class="text-right-num">Opening Balance</th>
              <th class="text-right-num">Customer Due Limit</th>
              <th>Remark</th>
              <th>Party Type</th>
              <th>Status</th>
              <th style="width:110px">Action</th>
            </tr>
            </thead>
            <tbody>
            @forelse($rows as $i => $r)
              <tr>
                <td>{{ $i+1 }}</td>
                <td>{{ $r['name'] }}</td>
                <td>{{ $r['company_name'] }}</td>
                <td>{{ $r['email'] }}</td>
                <td>{{ $r['address'] }}</td>
                <td>{{ $r['personal_phone'] }}</td>
                <td>{{ $r['executive'] }}</td>
                <td>{{ $r['area'] }}</td>
                <td class="text-right-num">{{ number_format($r['opening_balance'] ?? 0,2) }}</td>
                <td class="text-right-num">{{ number_format($r['due_limit'] ?? 0,2) }}</td>
                <td>{{ $r['remark'] }}</td>
                <td>{{ $r['party_type'] }}</td>
                <td>
                  <span class="label {{ ($r['status'] ?? 1) ? 'label-success':'label-default' }}">
                    {{ ($r['status'] ?? 1) ? 'Active':'Inactive' }}
                  </span>
                </td>
                <td>
                  <div class="actions">
                    <!-- Edit (modal) -->
                    <button type="button" class="btn btn-xs btn-info" data-toggle="modal" data-target="#edit{{ $i }}">
                      <i class="fa fa-pencil"></i>
                    </button>
                    <!-- Delete -->
                    <form action="{{ route('party.customers.csv.destroy', $i) }}" method="POST" onsubmit="return confirm('Delete this row?')" style="display:inline">
                      @csrf @method('DELETE')
                      <button class="btn btn-xs btn-danger"><i class="fa fa-trash"></i></button>
                    </form>
                  </div>

                  <!-- Edit Modal -->
                  <div class="modal fade" id="edit{{ $i }}">
                    <div class="modal-dialog modal-lg">
                      <form class="modal-content" action="{{ route('party.customers.csv.update',$i) }}" method="POST">
                        @csrf
                        <div class="modal-header">
                          <button type="button" class="close" data-dismiss="modal">&times;</button>
                          <h4 class="modal-title">Edit Row #{{ $i+1 }}</h4>
                        </div>
                        <div class="modal-body">
                          <div class="row">
                            <div class="col-md-6"><label>Customer Name</label>
                              <input class="form-control" name="name" value="{{ $r['name'] }}">
                            </div>
                            <div class="col-md-6"><label>Company Name</label>
                              <input class="form-control" name="company_name" value="{{ $r['company_name'] }}">
                            </div>
                            <div class="col-md-6"><label>Email</label>
                              <input class="form-control" name="email" value="{{ $r['email'] }}">
                            </div>
                            <div class="col-md-6"><label>Phone Personal</label>
                              <input class="form-control" name="personal_phone" value="{{ $r['personal_phone'] }}">
                            </div>
                            <div class="col-md-6"><label>Executive</label>
                              <input class="form-control" name="executive" value="{{ $r['executive'] }}">
                            </div>
                            <div class="col-md-6"><label>Area</label>
                              <input class="form-control" name="area" value="{{ $r['area'] }}">
                            </div>
                            <div class="col-md-12"><label>Address</label>
                              <input class="form-control" name="address" value="{{ $r['address'] }}">
                            </div>
                            <div class="col-md-4"><label>Opening Balance</label>
                              <input class="form-control" name="opening_balance" value="{{ $r['opening_balance'] }}">
                            </div>
                            <div class="col-md-4"><label>Customer Due Limit</label>
                              <input class="form-control" name="due_limit" value="{{ $r['due_limit'] }}">
                            </div>
                            <div class="col-md-4"><label>Party Type</label>
                              <input class="form-control" name="party_type" value="{{ $r['party_type'] }}">
                            </div>
                            <div class="col-md-12"><label>Remark</label>
                              <input class="form-control" name="remark" value="{{ $r['remark'] }}">
                            </div>
                            <div class="col-md-12" style="margin-top:6px">
                              <label><input type="checkbox" name="status" value="1" {{ ($r['status'] ?? 1) ? 'checked':'' }}> Active</label>
                            </div>
                          </div>
                        </div>
                        <div class="modal-footer">
                          <button class="btn btn-primary"><i class="fa fa-save"></i> Save</button>
                          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                        </div>
                      </form>
                    </div>
                  </div>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="14" style="background:#f5f8fc">No CSV rows found. Please upload a CSV file.</td>
              </tr>
            @endforelse
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </section>
</div>
@endsection
