﻿@extends('layouts.app')
@section('title', isset($customer) ? 'Edit Customer' : 'Add New Customer')

@push('styles')
<style>
  :root{ --border:#e5e7eb; }
  .card{background:#fff;border:1px solid var(--border);border-radius:10px;overflow:hidden}
  .card-head{display:flex;align-items:center;justify-content:space-between;padding:12px 14px;border-bottom:1px solid var(--border);background:linear-gradient(#f8fafc,#eef2f7)}
  .card-head h3{margin:0;font-size:18px;font-weight:600;color:#0f172a;display:flex;gap:8px;align-items:center}
  .btn-soft{display:inline-flex;align-items:center;gap:8px;padding:8px 12px;border-radius:8px;border:1px solid #d1d5db;background:#f8fafc;color:#0f172a;text-decoration:none;font-weight:500}
  .btn-soft:hover{background:#eef2f7}
  .body{padding:16px}
  .form-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px 16px}
  @media (max-width:1024px){.form-grid{grid-template-columns:1fr}}
  .field{display:grid;grid-template-columns:180px 1fr;gap:8px}
  .label-cell{background:#f1f5f9;border:1px solid var(--border);border-radius:8px;display:flex;align-items:center;padding:10px 12px;font-weight:500;color:#374151}
  .control,.select,textarea.control{width:100%;padding:10px 12px;border:1px solid var(--border);border-radius:8px;background:#fff;font-size:14px}
  textarea.control{min-height:42px;resize:vertical}
  .actions{display:flex;gap:10px;justify-content:flex-end;margin-top:14px}
  .btn-primary{background:#2563eb;border:1px solid #1e40af;color:#fff;border-radius:8px;padding:10px 14px;font-weight:600;display:inline-flex;align-items:center;gap:8px}
  .btn-secondary{background:#94a3b8;border:1px solid #64748b;color:#fff;border-radius:8px;padding:10px 14px;font-weight:500;display:inline-flex;align-items:center;gap:8px}
  .help{color:#dc2626;font-size:12.5px;margin-top:6px}
</style>
@endpush

@section('content')
@php
  $indexRoute = Route::has('customers.index') ? 'customers.index' : null;
  $storeRoute = isset($customer)
                  ? (Route::has('customers.update') ? route('customers.update', $customer->id) : '#')
                  : (Route::has('customers.store')  ? route('customers.store')  : '#');
@endphp

<div class="card">
  <div class="card-head">
    <h3><i class="fa-solid fa-id-card"></i> {{ isset($customer)?'Edit Customer':'Add New Customer' }}</h3>
    @if($indexRoute)<a href="{{ route($indexRoute) }}" class="btn-soft"><i class="fa-solid fa-table"></i> Customer List</a>@endif
  </div>

  <div class="body">
    @if(session('success'))
      <div class="flash" style="margin-bottom:12px;padding:10px 12px;border-radius:8px;border:1px solid #d1fae5;background:#ecfdf5;color:#065f46">
        <i class="fa-solid fa-check-circle"></i> {{ session('success') }}
      </div>
    @endif

    <form action="{{ $storeRoute }}" method="POST" enctype="multipart/form-data" autocomplete="off">
      @csrf
      @if(isset($customer)) @method('PUT') @endif

      <div class="form-grid">
        {{-- Col 1 --}}
        <div class="field">
          <div class="label-cell">Name *</div>
          <div>
            <input class="control" name="name" value="{{ old('name', $customer->name ?? '') }}" required>
            @error('name')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Personal Phone *</div>
          <div>
            <input class="control" name="personal_phone" value="{{ old('personal_phone', $customer->personal_phone ?? '') }}" required>
            @error('personal_phone')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Company</div>
          <div>
            <input class="control" name="company_name" value="{{ old('company_name', $customer->company_name ?? '') }}">
            @error('company_name')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Business Phone</div>
          <div>
            <input class="control" type="number" name="bussiness_phone" value="{{ old('bussiness_phone', $customer->bussiness_phone ?? '') }}">
            @error('bussiness_phone')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Email</div>
          <div>
            <input class="control" type="email" name="email" value="{{ old('email', $customer->email ?? '') }}">
            @error('email')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Address</div>
          <div>
            <input class="control" name="address" value="{{ old('address', $customer->address ?? '') }}">
            @error('address')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        {{-- Money --}}
        <div class="field">
          <div class="label-cell">Opening Balance</div>
          <div>
            <input class="control" type="number" step="0.01" name="opening_balance" value="{{ old('opening_balance', $customer->opening_balance ?? 0) }}">
            @error('opening_balance')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>
        <div class="field">
          <div class="label-cell">Due Limit</div>
          <div>
            <input class="control" type="number" step="0.01" name="due_limit" value="{{ old('due_limit', $customer->due_limit ?? 0) }}">
            @error('due_limit')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Customer Type</div>
          <div>
            <select class="select" name="customer_type">
              <option value="">- Select -</option>
              <option value="0" {{ old('customer_type', $customer->customer_type ?? '')==='0'?'selected':'' }}>Baki (0)</option>
              <option value="1" {{ old('customer_type', $customer->customer_type ?? '')==='1'?'selected':'' }}>Nagad (1)</option>
            </select>
            @error('customer_type')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Executive Name</div>
          <div>
            <input class="control" name="executive_name" value="{{ old('executive_name', $customer->executive_name ?? '') }}">
            @error('executive_name')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Party Type ID</div>
          <div>
            <input class="control" type="number" name="party_type_id" value="{{ old('party_type_id', $customer->party_type_id ?? '') }}">
            @error('party_type_id')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Area ID</div>
          <div>
            <input class="control" type="number" name="area_id" value="{{ old('area_id', $customer->area_id ?? '') }}">
            @error('area_id')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Discount Type</div>
          <div>
            <select class="select" name="discount_type">
              <option value="">- Select -</option>
              <option value="1" {{ old('discount_type', $customer->discount_type ?? '')==='1'?'selected':'' }}>%</option>
              <option value="2" {{ old('discount_type', $customer->discount_type ?? '')==='2'?'selected':'' }}>Flat</option>
            </select>
            @error('discount_type')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Discount</div>
          <div>
            <input class="control" type="number" step="0.01" name="discount" value="{{ old('discount', $customer->discount ?? '') }}">
            @error('discount')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Assume Rate</div>
          <div>
            <input class="control" type="number" step="0.01" name="assume_rate" value="{{ old('assume_rate', $customer->assume_rate ?? '') }}">
            @error('assume_rate')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Status</div>
          <div>
            <select class="select" name="status">
              <option value="1" {{ old('status', $customer->status ?? 1)==1?'selected':'' }}>Active</option>
              <option value="0" {{ old('status', $customer->status ?? 1)==0?'selected':'' }}>Inactive</option>
            </select>
            @error('status')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Customer ID</div>
          <div>
            <input class="control" name="customerId" value="{{ old('customerId', $customer->customerId ?? '') }}">
            @error('customerId')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Image (optional)</div>
          <div>
            <input class="control" type="file" name="image" accept="image/*">
            @error('image')<div class="help">{{ $message }}</div>@enderror
            @isset($customer->image)
              <div style="margin-top:6px;font-size:12.5px;color:#64748b">Current: {{ $customer->image }}</div>
            @endisset
          </div>
        </div>

        <div class="field">
          <div class="label-cell">Remarks</div>
          <div>
            <textarea class="control" name="remarks">{{ old('remarks', $customer->remarks ?? '') }}</textarea>
            @error('remarks')<div class="help">{{ $message }}</div>@enderror
          </div>
        </div>
      </div>

      <div class="actions">
        <button class="btn-primary" type="submit"><i class="fa-solid fa-floppy-disk"></i> Save</button>
        <button class="btn-secondary" type="reset"><i class="fa-solid fa-rotate"></i> Reset</button>
      </div>
    </form>
  </div>
</div>
@endsection