﻿@extends('layouts.app')

@section('content')
<div class="container-fluid odl">

  {{-- Header + Add button --}}
  <div class="odl__head card">
    <div class="odl__head-row">
      <div class="odl__title">
        <i class="fas fa-list-ul me-2"></i> Order Delivery List
      </div>
      <a href="{{ route('order_delivery.create') }}" class="odl__add btn btn-primary">
        <i class="fas fa-plus me-2"></i> Add Order Delivery
      </a>
    </div>
  </div>

  {{-- Filter toolbar --}}
  <div class="odl__filters card">
    <form action="{{ route('order_delivery.index') }}" method="GET" id="odlSearchForm" autocomplete="off">
      <div class="odl__grid">
        {{-- Company --}}
        <div class="odl__cell">
          <label class="odl__label">Company</label>
          <div class="odl__selectwrap">
            <select name="company_id" class="odl__input">
              <option value="">-Company Name-</option>
              @foreach($companies ?? [] as $c)
                <option value="{{ $c->id }}" @selected(request('company_id')==$c->id)>{{ $c->name }}</option>
              @endforeach
            </select>
            <span class="odl__caret"><i class="fas fa-caret-down"></i></span>
          </div>
        </div>

        {{-- Customer --}}
        <div class="odl__cell">
          <label class="odl__label">Customer</label>
          <div class="odl__selectwrap">
            <select name="customer_id" class="odl__input">
              <option value="">-Select Customer-</option>
              @foreach($customers ?? [] as $cu)
                <option value="{{ $cu->id }}" @selected(request('customer_id')==$cu->id)>{{ $cu->name }}</option>
              @endforeach
            </select>
            <span class="odl__caret"><i class="fas fa-caret-down"></i></span>
          </div>
        </div>

        {{-- Challan No --}}
        <div class="odl__cell">
          <label class="odl__label">Challan Number</label>
          <input type="text" name="challan_no" value="{{ request('challan_no') }}" class="odl__input" placeholder="Search by Challan No">
        </div>

        {{-- From Date --}}
        <div class="odl__cell">
          <label class="odl__label">From Date</label>
          <div class="odl__iconinput">
            <input type="text" name="date_from" value="{{ request('date_from') }}" class="odl__input" placeholder="mm/dd/yyyy">
            <i class="far fa-calendar-alt"></i>
          </div>
        </div>

        {{-- To Date --}}
        <div class="odl__cell">
          <label class="odl__label">To Date</label>
          <div class="odl__iconinput">
            <input type="text" name="date_to" value="{{ request('date_to') }}" class="odl__input" placeholder="mm/dd/yyyy">
            <i class="far fa-calendar-alt"></i>
          </div>
        </div>

        {{-- Actions (search/reset on right) --}}
        <div class="odl__actions">
          <button type="submit" class="btn btn-primary odl__btn-search">
            <i class="fas fa-search me-2"></i> Search
          </button>
          <a href="{{ route('order_delivery.index') }}" class="btn btn-light odl__btn-reset" title="Reset">
            <i class="fas fa-sync"></i>
          </a>
        </div>
      </div>
    </form>
  </div>

  {{-- Table --}}
  <div class="card odl__tablewrap">
    <div class="table-responsive">
      <table class="table table-sm odl__table">
        <colgroup>
          <col style="width:70px">               {{-- SL --}}
          <col style="width:160px">              {{-- Challan No --}}
          <col style="width:200px">              {{-- Company --}}
          <col style="width:220px">              {{-- Customer Name --}}
          <col style="width:120px">              {{-- Date --}}
          <col style="width:280px">              {{-- Delivery Address --}}
          <col style="width:160px">              {{-- Driver Name --}}
          <col style="width:140px">              {{-- Driver Phone --}}
          <col style="width:120px">              {{-- Vehicle No. --}}
          <col style="width:110px">              {{-- Cho. No. --}}
          <col style="width:110px">              {{-- Total Bag --}}
          <col style="width:110px">              {{-- Total Kg --}}
          <col style="width:140px">              {{-- Total Amount --}}
          <col style="width:120px">              {{-- Action --}}
        </colgroup>
        <thead>
          <tr>
            <th>SL</th>
            <th>Challan No</th>
            <th>Company</th>
            <th>Customer Name</th> {{-- resized per your mark-up --}}
            <th>Date</th>
            <th>Delivery Address</th> {{-- resized per your mark-up --}}
            <th>Driver Name</th>
            <th>Driver Phone</th>
            <th>Vehicle No.</th>
            <th>Cho. No.</th>
            <th>Total Bag</th>
            <th>Total Kg</th>
            <th>Total Amount</th>
            <th class="text-center">Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($deliveries ?? [] as $i => $row)
            <tr>
              <td>{{ $loop->iteration + ($deliveries->firstItem() - 1) }}</td>
              <td>{{ $row->challan_no }}</td>
              <td>{{ $row->company->name ?? '-' }}</td>
              <td>{{ $row->customer->name ?? '-' }}</td>
              <td>{{ \Carbon\Carbon::parse($row->date)->format('Y-m-d') }}</td>
              <td class="text-truncate" title="{{ $row->delivery_address }}">{{ $row->delivery_address }}</td>
              <td>{{ $row->driver_name }}</td>
              <td>{{ $row->driver_phone }}</td>
              <td>{{ $row->vehicle_no }}</td>
              <td>{{ $row->cho_no }}</td>
              <td class="text-end">{{ number_format($row->total_bag, 0) }}</td>
              <td class="text-end">{{ number_format($row->total_kg, 2) }}</td>
              <td class="text-end">{{ number_format($row->total_amount, 2) }}</td>
              <td class="text-center">
                <a href="{{ route('order-deliveries.show',$row->id) }}" class="odl__act odl__act-view" title="View"><i class="fas fa-eye"></i></a>
                <a href="{{ route('order-deliveries.edit',$row->id) }}" class="odl__act odl__act-edit" title="Edit"><i class="fas fa-edit"></i></a>
                <form action="{{ route('order-deliveries.destroy',$row->id) }}" method="POST" class="d-inline"
                      onsubmit="return confirm('Delete this delivery?');">
                  @csrf @method('DELETE')
                  <button type="submit" class="odl__act odl__act-del" title="Delete"><i class="fas fa-trash-alt"></i></button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="14" class="text-center text-muted py-4">No data found!</td>
            </tr>
          @endforelse
        </tbody>
      </table>
    </div>

    {{-- Pagination (if you paginate) --}}
    @if(!empty($deliveries) && method_exists($deliveries,'links'))
      <div class="px-3 pb-3">
        {{ $deliveries->links() }}
      </div>
    @endif
  </div>
</div>
@endsection

@push('styles')
<style>
/* ============ Visual system ============ */
.odl .card{border:1px solid #dfe5ec;border-radius:4px;background:#fff;margin-bottom:12px}
.odl__head{padding:10px 12px;background:#f3f7fb;border-color:#dfe5ec}
.odl__head-row{display:flex;align-items:center;justify-content:space-between}
.odl__title{font-weight:600;color:#3f4d67;font-size:16px}
.odl__add{font-weight:600}

/* Filters */
.odl__filters{padding:10px 12px}
.odl__grid{
  display:grid;
  grid-template-columns: 1fr 1fr 1fr 160px 160px 150px;
  gap:10px 14px;
  align-items:end;
}
.odl__cell{display:flex;flex-direction:column;min-width:0}
.odl__label{font-size:12px;color:#5d6b7a;margin-bottom:6px;font-weight:600}
.odl__input{
  height:38px;border:1px solid #cfd8e3;border-radius:3px;padding:6px 10px;line-height:24px;
  width:100%;background:#fff
}
.odl__input::placeholder{color:#b7c2cf}
.odl__selectwrap{position:relative}
.odl__caret{position:absolute;right:10px;top:50%;transform:translateY(-50%);color:#8ea1b5;pointer-events:none}
.odl__iconinput{position:relative}
.odl__iconinput i{position:absolute;right:10px;top:50%;transform:translateY(-50%);color:#8ea1b5}

.odl__actions{
  display:flex;align-items:end;justify-content:flex-end;gap:8px;
}
.odl__btn-search{min-width:110px;font-weight:600}
.odl__btn-reset{width:38px;height:38px;display:inline-flex;align-items:center;justify-content:center}

/* Table */
.odl__tablewrap{padding:0}
.odl__table{margin-bottom:0;table-layout:fixed;border-color:#e6ebf1}
.odl__table thead th{
  background:#d8e5ff;color:#263442;font-weight:600;border-bottom:1px solid #e6ebf1;white-space:nowrap;
  height:42px;vertical-align:middle;padding:8px 10px
}
.odl__table tbody td{
  height:42px;vertical-align:middle;border-top:1px solid #edf1f6;padding:8px 10px
}
.odl__table .text-truncate{max-width: 260px; overflow:hidden; text-overflow:ellipsis; white-space:nowrap}

/* Action pills */
.odl__act{width:30px;height:30px;border-radius:4px;border:0;display:inline-flex;align-items:center;justify-content:center;margin:0 2px}
.odl__act-view{background:#3bb273;color:#fff}
.odl__act-edit{background:#f3a23a;color:#fff}
.odl__act-del{background:#e2574c;color:#fff}
.odl__act:hover{opacity:.9}

/* Responsive */
@media (max-width:1200px){
  .odl__grid{grid-template-columns:1fr 1fr;gap:10px}
  .odl__actions{justify-content:flex-start}
}
</style>
@endpush
