﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  {{-- Title row --}}
  <div class="do-header">
    <div class="do-title">
      <i class="fas fa-plus-circle"></i>
      <span>Delivery Order</span>
    </div>
    <a href="{{ route('order_delivery.index') }}" class="do-back">← BACK TO LIST</a>
  </div>

  {{-- 3 boxes in a row (same layout as screenshot) --}}
  <div class="do-grid">
    <!-- Company -->
    <div class="do-field">
      <div class="do-label">Company</div>
      <select class="do-input">
        <option value="">-Select Company-</option>
        @foreach(($companies ?? []) as $c)
          <option value="{{ $c->id }}">{{ $c->name }}</option>
        @endforeach
      </select>
    </div>

    <!-- Customer -->
    <div class="do-field">
      <div class="do-label">Customer</div>
      <select class="do-input">
        <option value="">-Select Customer-</option>
        @foreach(($customers ?? []) as $cu)
          <option value="{{ $cu->id }}">{{ $cu->name }}</option>
        @endforeach
      </select>
    </div>

    <!-- Order Id + small round arrow button -->
    <div class="do-field do-with-btn">
      <div class="do-label">Order Id</div>
      <select class="do-input">
        <option value="">- Select Order Id -</option>
        @foreach(($orderIds ?? []) as $oid)
          <option value="{{ is_array($oid)?($oid['id']??$oid['value']):$oid }}">
            {{ is_array($oid)?($oid['label']??$oid['id']??$oid['value']):$oid }}
          </option>
        @endforeach
      </select>
      <button type="button" class="do-go" title="Proceed">
        <i class="fas fa-arrow-right"></i>
      </button>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --box-blue:#b9c9ff;   /* outer border (light blue) */
  --box-blue2:#cfe0ff;  /* subtle inner border */
  --label-bg:#efeff3;   /* left label bg */
  --line:#e8ecf2;       /* dashed line under title */
  --text:#2f4254;
  --back:#6f88b7;
}

/* header */
.do-header{
  display:flex;justify-content:space-between;align-items:center;
  margin:2px 0 12px;padding-bottom:10px;border-bottom:1px dashed var(--line);
}
.do-title{display:flex;align-items:center;gap:8px;color:var(--text);font-weight:700;font-size:20px;}
.do-title i{color:#6aa3c6}
.do-back{
  font-size:12.5px;border:1px solid var(--box-blue2);padding:6px 10px;border-radius:3px;
  text-decoration:none;color:var(--back);background:#f7faff
}
.do-back:hover{background:#eef5ff}

/* grid (3 columns exactly like screenshot) */
.do-grid{
  display:grid;
  grid-template-columns: 1fr 1fr 1fr;
  gap: 24px;
}

/* field box */
.do-field{
  display:grid; grid-template-columns: 120px 1fr; align-items:center;
  border:2px solid var(--box-blue); border-radius:3px; background:#fff; overflow:hidden;
}
.do-label{
  background:var(--label-bg); padding:8px 12px; font-weight:700; color:#222;
  border-right:1px solid var(--box-blue2);
}
.do-input{
  height:36px; border:0; width:100%; padding:6px 10px; outline:0; background:#fff;
}
.do-input:focus{outline:0}

/* with right small round button */
.do-with-btn{grid-template-columns: 120px 1fr 36px;}
.do-go{
  height:36px;width:36px; border:1px solid var(--box-blue2); border-left:0;
  background:#fff; color:#5b6fa3; display:flex;align-items:center;justify-content:center;
  border-radius:0 3px 3px 0;
}
.do-go:hover{background:#f1f6ff}
</style>
@endpush
