﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Order List</span>
      </div>

      <a href="{{ route('order.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i><span>Add Order</span>
      </a>
    </div>

    <div class="sx-body">

      {{-- FILTER BAR (same layout as screenshot) --}}
      <form method="GET" action="{{ route('order.index') }}" id="filterForm">
        <div class="sx-filtergrid">
          <div class="sx-frow">
            <div class="sx-fcol">
              <select name="customer_id" class="sx-input">
                <option value="">-Select Customer-</option>
                @foreach($customers ?? [] as $c)
                  <option value="{{ $c->id }}" @selected(request('customer_id')==$c->id)>{{ $c->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="sx-fcol">
              <select name="employee_id" class="sx-input">
                <option value="">-Select Employee-</option>
                @foreach($employees ?? [] as $e)
                  <option value="{{ $e->id }}" @selected(request('employee_id')==$e->id)>{{ $e->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="sx-fcol">
              <select name="executive_id" class="sx-input">
                <option value="">-Select Executive-</option>
                @foreach($executives ?? [] as $ex)
                  <option value="{{ $ex->id }}" @selected(request('executive_id')==$ex->id)>{{ $ex->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="sx-fcol">
              <select name="area_id" class="sx-input">
                <option value="">-Select Area-</option>
                @foreach($areas ?? [] as $a)
                  <option value="{{ $a->id }}" @selected(request('area_id')==$a->id)>{{ $a->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-frow">
            <div class="sx-fcol">
              <select name="company_id" class="sx-input">
                <option value="">-Company Name-</option>
                @foreach($companies ?? [] as $co)
                  <option value="{{ $co->id }}" @selected(request('company_id')==$co->id)>{{ $co->name }}</option>
                @endforeach
              </select>
            </div>

            <div class="sx-fcol">
              <input type="text" name="invoice_no" value="{{ request('invoice_no') }}" class="sx-input" placeholder="Invoice No">
            </div>

            <div class="sx-fcol">
              <div class="sx-dategrp">
                <input type="date" name="date_from" value="{{ request('date_from') }}" class="sx-input sx-date" placeholder="From Date">
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
              </div>
            </div>

            <div class="sx-fcol">
              <div class="sx-dategrp">
                <input type="date" name="date_to" value="{{ request('date_to') }}" class="sx-input sx-date" placeholder="To Date">
                <span class="sx-datebtn"><i class="fas fa-exchange-alt"></i></span>
              </div>
            </div>

            <div class="sx-fcol">
              <select name="status" class="sx-input">
                <option value="">--Status--</option>
                <option value="pending"   @selected(request('status')=='pending')>Pending</option>
                <option value="approved"  @selected(request('status')=='approved')>Approved</option>
                <option value="cancelled" @selected(request('status')=='cancelled')>Cancelled</option>
                <option value="delivered" @selected(request('status')=='delivered')>Delivered</option>
              </select>
            </div>

            <div class="sx-fcol sx-factions">
              <button type="submit" class="sx-search"><i class="fas fa-search"></i> Search</button>
              <a href="{{ route('order.index') }}" class="sx-refresh" title="Reset"><i class="fas fa-sync-alt"></i></a>
            </div>
          </div>
        </div>
      </form>

      {{-- TABLE --}}
      <div class="table-responsive">
        <table class="table sx-table sx-table-list">
          <colgroup>
            <col style="width:70px">
            <col>
            <col style="width:140px">
            <col>
            <col style="width:140px">
            <col style="width:160px">
            <col style="width:160px">
            <col style="width:140px">
            <col style="width:110px">
            <col style="width:130px">
            <col style="width:120px">
            <col style="width:110px">
            <col>
            <col style="width:130px">
          </colgroup>

          <thead>
            <tr>
              <th>SL</th>
              <th>Company</th>
              <th>Invoice No</th>
              <th>Customer Name</th>
              <th>Customer Phone</th>
              <th>Executive Name</th>
              <th>Employee Name</th>
              <th>Area</th>
              <th>Date</th>
              <th>Delivery Date</th>
              <th>Subtotal</th>
              <th>Status</th>
              <th>Cancel Reason</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>

          <tbody>
            @forelse($orders ?? [] as $i => $row)
              <tr>
                <td>{{ $orders->firstItem() + $i }}</td>
                <td>{{ $row->company->name ?? '-' }}</td>
                <td>{{ $row->invoice_no ?? '-' }}</td>
                <td>{{ $row->customer->name ?? '-' }}</td>
                <td>{{ $row->customer->phone ?? '-' }}</td>
                <td>{{ $row->executive->name ?? '-' }}</td>
                <td>{{ $row->employee->name ?? '-' }}</td>
                <td>{{ $row->area->name ?? '-' }}</td>
                <td>{{ \Carbon\Carbon::parse($row->date)->format('Y-m-d') }}</td>
                <td>{{ $row->delivery_date ? \Carbon\Carbon::parse($row->delivery_date)->format('Y-m-d') : '-' }}</td>
                <td>{{ number_format($row->subtotal ?? 0, 2) }}</td>
                <td>{{ ucfirst($row->status ?? 'pending') }}</td>
                <td>{{ $row->cancel_reason ?? '' }}</td>
                <td class="text-center sx-actions">
                  <a class="sx-btn sx-btn-view" href="{{ route('order.show',$row->id) }}"><i class="fas fa-eye"></i></a>
                  <a class="sx-btn sx-btn-edit" href="{{ route('order.edit',$row->id) }}"><i class="fas fa-edit"></i></a>
                  <form action="{{ route('order.destroy',$row->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this order?')">
                    @csrf @method('DELETE')
                    <button type="submit" class="sx-btn sx-btn-del"><i class="fas fa-trash-alt"></i></button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="14" class="text-center text-muted py-4">No data found!</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      @if(isset($orders) && method_exists($orders,'links'))
        <div class="mt-2">
          {{ $orders->withQueryString()->links() }}
        </div>
      @endif

      {{-- (Optional) Export icons row – drop in your routes if needed --}}
      {{-- <div class="mt-3">
        <a href="{{ route('order.export',['type'=>'xlsx'] + request()->all()) }}"><img src="{{ asset('img/xls.png') }}" height="24"></a>
        <a href="{{ route('order.export',['type'=>'pdf'] + request()->all()) }}" class="ms-2"><img src="{{ asset('img/pdf.png') }}" height="24"></a>
      </div> --}}
    </div>
  </div>

</div>
@endsection


@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250);background:#fff;border-radius:3px;}
.sx-head{display:flex;align-items:center;justify-content:space-between;background:var(--sx-blue-100);border-bottom:1px solid var(--sx-gray-250);padding:10px 12px;}
.sx-head-left{display:flex;gap:8px;align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title);font-weight:600;font-size:18px;}
.sx-head-link{display:inline-flex;align-items:center;gap:8px;background:var(--sx-blue-200);border:1px solid var(--sx-blue-300);color:#2f6fa8;text-decoration:none;border-radius:3px;padding:6px 10px;font-weight:600;}

.sx-body{padding:12px;}
.sx-input{width:100%;height:34px;line-height:34px;padding:4px 10px;border:1px solid var(--sx-gray-300);border-radius:3px;background:#fff;}
.sx-input::placeholder{color:#b8c3cf;}

.sx-filtergrid{display:flex;flex-direction:column;gap:8px;margin-bottom:10px;}
.sx-frow{display:grid;grid-template-columns:1fr 1fr 1fr 1fr 1fr 120px;column-gap:12px;}
.sx-frow:first-child{grid-template-columns:1fr 1fr 1fr 1fr;}
.sx-fcol{display:flex;}
.sx-factions{align-items:center;gap:8px;justify-content:flex-start;}
.sx-search{height:34px;padding:0 12px;border:1px solid #5aa0d6;background:#5aa0d6;color:#fff;border-radius:4px;font-weight:600;}
.sx-refresh{display:inline-flex;align-items:center;justify-content:center;width:34px;height:34px;border:1px solid var(--sx-gray-300);border-radius:4px;color:#6b7786;text-decoration:none;background:#fff;}

.sx-dategrp{display:flex;width:100%;}
.sx-date{border-right:0!important;}
.sx-date::-webkit-calendar-picker-indicator{display:none;}
.sx-datebtn{width:34px;height:34px;display:inline-flex;align-items:center;justify-content:center;background:#e6ebf1;border:1px solid var(--sx-gray-300);border-left:0;border-radius:0 3px 3px 0;color:#6d7e90;font-size:12px;}

.sx-table{width:100%;border:1px solid var(--sx-gray-250);table-layout:fixed;margin:0;}
.sx-table thead th{background:#d8e5ff;color:#223;font-weight:600;padding:8px 10px;border-bottom:1px solid var(--sx-gray-200);white-space:nowrap;}
.sx-table tbody td{padding:10px;vertical-align:middle;border-top:1px solid var(--sx-gray-220);}
.sx-table-list thead th{background:#d7e5ff;}

.sx-actions .sx-btn{display:inline-flex;align-items:center;justify-content:center;width:30px;height:30px;border-radius:4px;margin:0 2px;border:0;text-decoration:none;color:#fff;}
.sx-btn-view{background:#3bb273;}
.sx-btn-edit{background:#f3a23a;}
.sx-btn-del{background:#e2574c;}
.sx-btn[type="submit"]{cursor:pointer;}

@media (max-width: 1199.98px){
  .sx-frow{grid-template-columns:1fr 1fr 1fr; row-gap:8px;}
  .sx-frow:first-child{grid-template-columns:1fr 1fr;}
}
@media (max-width: 767.98px){
  .sx-frow, .sx-frow:first-child{grid-template-columns:1fr;}
}
</style>
@endpush