﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="ox-card">
    {{-- Header --}}
    <div class="ox-head">
      <div class="ox-left">
        <i class="fas fa-cog"></i>
        <span>Create Order</span>
      </div>
      <a href="{{ route('order.index') }}" class="ox-list">
        <i class="fas fa-list"></i> Order List
      </a>
    </div>

    <div class="ox-body">
      <form action="{{ route('order.store') }}" method="POST" id="orderForm" autocomplete="off">
        @csrf

        {{-- Top grid (exactly like screenshot) --}}
        <div class="ox-grid">
          <div class="ox-row">
            <div class="ox-label">Company</div>
            <select name="company_id" class="ox-inp" required>
              <option value="">-Select Company-</option>
              @foreach(($companies ?? []) as $co)
                <option value="{{ $co->id }}">{{ $co->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="ox-row">
            <div class="ox-label">Customer</div>
            <select name="customer_id" class="ox-inp" required>
              <option value="">-Select Customer-</option>
              @foreach(($customers ?? []) as $cu)
                <option value="{{ $cu->id }}">{{ $cu->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="ox-row">
            <div class="ox-label">Employee</div>
            <select name="employee_id" class="ox-inp">
              <option value="">-Employee Name-</option>
              @foreach(($employees ?? []) as $e)
                <option value="{{ $e->id }}">{{ $e->name }}</option>
              @endforeach
            </select>
          </div>

          <div class="ox-row">
            <div class="ox-label">Date</div>
            <div class="ox-icwrap">
              <input type="date" name="date" class="ox-inp" value="{{ date('Y-m-d') }}" required>
              <span class="ox-ic"><i class="far fa-calendar"></i></span>
            </div>
          </div>

          <div class="ox-row">
            <div class="ox-label">Deli. Date</div>
            <div class="ox-icwrap">
              <input type="date" name="delivery_date" class="ox-inp" placeholder="Delivery Date">
              <span class="ox-ic"><i class="far fa-calendar-check"></i></span>
            </div>
          </div>

          <div class="ox-row">
            <div class="ox-label">Cus. Due</div>
            <input type="text" class="ox-inp ox-read" value="0.00" readonly>
          </div>
        </div>

        <div class="ox-section">Order</div>

        {{-- Table --}}
        <div class="table-responsive">
          <table class="table ox-table" id="orderTable">
            <colgroup>
              <col style="width:60px">
              <col>
              <col style="width:160px">
              <col style="width:200px">
              <col style="width:170px">
              <col style="width:160px">
              <col style="width:170px">
              <col style="width:170px">
              <col style="width:120px">
            </colgroup>

            <thead>
              <tr>
                <th>SL.</th>
                <th>Product</th>
                <th>Unit</th>
                <th>Category</th>
                <th>Available Qty</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Subtotal</th>
                <th class="text-center"></th>
              </tr>
            </thead>

            <tbody id="oxRows">
              <tr class="ox-tr">
                <td class="text-center ox-sl">1</td>
                <td>
                  <div class="ox-prodcell">
                    <select name="items[0][product_id]" class="ox-inp ox-product" required>
                      <option value="">-select product-</option>
                      @foreach(($products ?? []) as $p)
                        <option value="{{ $p->id }}"
                          data-unit="{{ $p->unit->name ?? '' }}"
                          data-cat="{{ $p->category_id ?? '' }}"
                          data-qty="{{ number_format($p->available_qty ?? 0, 2, '.', '') }}"
                          data-price="{{ number_format($p->price ?? 0, 2, '.', '') }}">
                          {{ $p->name }}
                        </option>
                      @endforeach
                    </select>
                    <button type="button" class="ox-info" title="Product info"><i class="fas fa-info"></i></button>
                  </div>
                </td>
                <td><input type="text" class="ox-inp ox-read ox-unit" placeholder="Unit" readonly></td>
                <td>
                  <select name="items[0][category_id]" class="ox-inp ox-cat">
                    <option value="">-Category-</option>
                    @foreach(($categories ?? []) as $cat)
                      <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                    @endforeach
                  </select>
                </td>
                <td><input type="text" class="ox-inp ox-read ox-avail" placeholder="Available Qty" readonly></td>
                <td><input type="number" step="0.01" min="0" name="items[0][qty]"   class="ox-inp ox-qty"   placeholder="Qty"></td>
                <td><input type="number" step="0.01" min="0" name="items[0][price]" class="ox-inp ox-price" placeholder="Unit Price"></td>
                <td><input type="text" class="ox-inp ox-read ox-sub" value="0.00" readonly></td>
                <td class="text-center">
                  <div class="ox-actions">
                    <button type="button" class="ox-minus rem" title="Remove"><i class="fas fa-minus"></i></button>
                    <button type="button" class="ox-plus add"  title="Add"><i class="fas fa-plus"></i></button>
                  </div>
                </td>
              </tr>

              {{-- inline “Total” row inside table (like screenshot) --}}
              <tr class="ox-inline-total">
                <td colspan="6"></td>
                <td class="ox-inline-total-label">Total</td>
                <td><input type="text" id="tableTotal" class="ox-inp ox-read" value="0.00" readonly></td>
                <td></td>
              </tr>
            </tbody>
          </table>
        </div>

        {{-- Right side total panel + Save (exact look) --}}
        <div class="ox-bottom">
          <div class="ox-totalbox">
            <div class="ox-totaltext">Total:</div>
            <input type="text" id="grandTotal" class="ox-inp ox-read" value="0.00" readonly>
          </div>
          <button type="submit" class="ox-save"><i class="far fa-save"></i> Save</button>
        </div>

      </form>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --bord:#dfe5ec; --thead:#e7f0ff; --lbl:#f2f5f9; --txt:#2f4254;
  --info:#e6f2ff; --info-b:#b7c6da; --minus:#d86357; --plus:#f4a328;
  --save:#5cb85c; --save-b:#479b52; --headbg:#f3f7fb; --btnb:#cfe0f7;
}
.ox-card{border:1px solid var(--bord); background:#fff; border-radius:3px;}
.ox-head{display:flex;justify-content:space-between;align-items:center;background:var(--headbg);border-bottom:1px solid var(--bord);padding:10px 12px;}
.ox-left{display:flex;align-items:center;gap:8px;color:#2b3d57;font-weight:700}
.ox-list{display:inline-flex;align-items:center;gap:6px;border:1px solid var(--btnb);background:#eaf2fb;color:#2f6fa8;padding:6px 10px;border-radius:3px;text-decoration:none;font-weight:600;}
.ox-body{padding:14px}

/* Top grid */
.ox-grid{display:grid;grid-template-columns:1fr 1fr;gap:12px 22px;margin-bottom:12px}
.ox-row{display:grid;grid-template-columns:140px 1fr;align-items:center;gap:8px}
.ox-label{background:var(--lbl);border:1px solid #e3e9ef;border-radius:3px;padding:8px 10px;font-weight:700;color:#5d6b7a}
.ox-inp{width:100%;height:36px;border:1px solid #c9d5e2;border-radius:3px;padding:6px 10px}
.ox-inp:focus{outline:0;border-color:#b6c6e0}
.ox-read{background:#eef2f6}
.ox-icwrap{position:relative}
.ox-ic{position:absolute;right:8px;top:8px;color:#6e7f91}

/* Section title */
.ox-section{font-size:22px;color:#3a6ea5;font-weight:700;margin:12px 0 8px}

/* Table */
.ox-table{width:100%;border:1px solid var(--bord);margin:0;border-collapse:separate;border-spacing:0;table-layout:fixed}
.ox-table thead th{background:var(--thead);border-bottom:1px solid var(--bord);border-right:1px solid var(--bord);padding:8px 10px;font-weight:700;color:#30465a;white-space:nowrap}
.ox-table thead th:last-child{border-right:0}
.ox-table tbody td{border-top:1px solid var(--bord);border-right:1px solid var(--bord);padding:6px 8px;vertical-align:middle}
.ox-table tbody td:last-child{border-right:0}

/* Product cell */
.ox-prodcell{display:flex;align-items:center;gap:6px}
.ox-info{width:36px;height:36px;border:1px solid var(--info-b);background:var(--info);color:#2f6fa8;border-radius:3px;display:inline-flex;align-items:center;justify-content:center}

/* Actions */
.ox-actions{display:flex;gap:8px;justify-content:center}
.ox-minus,.ox-plus{width:38px;height:34px;border-radius:4px;border:0;color:#fff;display:inline-flex;align-items:center;justify-content:center}
.ox-minus{background:var(--minus)}
.ox-plus{background:var(--plus)}

/* Inline table total row */
.ox-inline-total td{border-top:0}
.ox-inline-total-label{font-weight:700;text-align:right;background:#f7f9fd;border:1px solid var(--bord)}

/* Bottom total panel + Save */
.ox-bottom{display:flex;justify-content:flex-end;align-items:center;gap:16px;margin-top:10px}
.ox-totalbox{display:flex;align-items:center;gap:10px;border:1px solid var(--bord);padding:10px 12px;border-radius:3px;background:#fff}
.ox-totaltext{font-weight:700;color:#2f4254;min-width:46px;text-align:right}
.ox-save{display:inline-flex;align-items:center;gap:6px;border:1px solid var(--save-b);background:var(--save);color:#fff;padding:7px 12px;border-radius:3px;font-weight:700}
</style>
@endpush

@push('scripts')
<script>
(function(){
  let row = 1;
  const tbody  = document.getElementById('oxRows');
  const gTotal = document.getElementById('grandTotal');
  const tTotal = document.getElementById('tableTotal');

  function renumber(){
    document.querySelectorAll('#oxRows .ox-tr').forEach((tr,i)=> tr.querySelector('.ox-sl').textContent = i+1);
  }
  function fmt(n){ return (Number(n)||0).toFixed(2); }
  function calcSub(tr){
    const q   = parseFloat(tr.querySelector('.ox-qty')?.value || 0);
    const pr  = parseFloat(tr.querySelector('.ox-price')?.value || 0);
    tr.querySelector('.ox-sub').value = fmt(q*pr);
  }
  function calcGrand(){
    let sum = 0;
    document.querySelectorAll('.ox-sub').forEach(i=> sum += parseFloat(i.value||0));
    gTotal.value = tTotal.value = fmt(sum);
  }

  // product change -> unit/avail/price, auto category
  document.addEventListener('change', function(e){
    if(!e.target.classList.contains('ox-product')) return;
    const tr  = e.target.closest('tr');
    const op  = e.target.selectedOptions[0];
    tr.querySelector('.ox-unit').value  = op?.dataset?.unit || '';
    tr.querySelector('.ox-avail').value = op?.dataset?.qty  || '';
    const priceInp = tr.querySelector('.ox-price');
    if(priceInp.value === '') priceInp.value = op?.dataset?.price || '';
    const catSel = tr.querySelector('.ox-cat');
    if(catSel && op?.dataset?.cat){ catSel.value = op.dataset.cat; }
  });

  // qty/price -> subtotal & totals
  document.addEventListener('input', function(e){
    if(!(e.target.classList.contains('ox-qty') || e.target.classList.contains('ox-price'))) return;
    const tr = e.target.closest('tr'); calcSub(tr); calcGrand();
  });

  // add row
  document.addEventListener('click', function(e){
    if(!e.target.closest('.ox-plus')) return;
    const i = row++;
    const tpl = `
      <tr class="ox-tr">
        <td class="text-center ox-sl">${i+1}</td>
        <td>
          <div class="ox-prodcell">
            <select name="items[${i}][product_id]" class="ox-inp ox-product" required>
              <option value="">-select product-</option>
              @foreach(($products ?? []) as $p)
                <option value="{{ $p->id }}"
                  data-unit="{{ $p->unit->name ?? '' }}"
                  data-cat="{{ $p->category_id ?? '' }}"
                  data-qty="{{ number_format($p->available_qty ?? 0, 2, '.', '') }}"
                  data-price="{{ number_format($p->price ?? 0, 2, '.', '') }}">
                  {{ $p->name }}
                </option>
              @endforeach
            </select>
            <button type="button" class="ox-info"><i class="fas fa-info"></i></button>
          </div>
        </td>
        <td><input type="text" class="ox-inp ox-read ox-unit" placeholder="Unit" readonly></td>
        <td>
          <select name="items[${i}][category_id]" class="ox-inp ox-cat">
            <option value="">-Category-</option>
            @foreach(($categories ?? []) as $cat)
              <option value="{{ $cat->id }}">{{ $cat->name }}</option>
            @endforeach
          </select>
        </td>
        <td><input type="text" class="ox-inp ox-read ox-avail" placeholder="Available Qty" readonly></td>
        <td><input type="number" step="0.01" min="0" name="items[${i}][qty]"   class="ox-inp ox-qty"   placeholder="Qty"></td>
        <td><input type="number" step="0.01" min="0" name="items[${i}][price]" class="ox-inp ox-price" placeholder="Unit Price"></td>
        <td><input type="text" class="ox-inp ox-read ox-sub" value="0.00" readonly></td>
        <td class="text-center">
          <div class="ox-actions">
            <button type="button" class="ox-minus rem"><i class="fas fa-minus"></i></button>
            <button type="button" class="ox-plus add"><i class="fas fa-plus"></i></button>
          </div>
        </td>
      </tr>`;
    // insert before inline total row
    document.querySelector('.ox-inline-total').insertAdjacentHTML('beforebegin', tpl);
    renumber();
  });

  // remove row
  document.addEventListener('click', function(e){
    if(!e.target.closest('.ox-minus')) return;
    const rows = document.querySelectorAll('#oxRows .ox-tr');
    if(rows.length <= 1){ alert('At least one item is required'); return; }
    e.target.closest('tr').remove();
    renumber(); calcGrand();
  });
})();
</script>
@endpush
