﻿{{-- resources/views/employee/index.blade.php --}}
@extends('layouts.app')
@section('title','Employee List')

@push('styles')
<style>
  /* ====== RESET / BASE ====== */
  :root{
    --border:#d6dee6;
    --head:#eff3f7;
    --text:#2b3f55;
    --text-head:#263e59;
    --bg:#f5f7fa;
    --blue:#1e88e5; --blue-b:#1b76c4;
    --green:#43a047; --green-b:#378b3a;
    --info:#1e88e5; --info-b:#1b76c4;
    --edit:#2e7d32; --edit-b:#2a6b2b;
    --del:#e53935;  --del-b:#c22f2d;
  }
  html,body{background:var(--bg)}
  .wrap{background:#fff;border:1px solid var(--border);border-radius:3px}

  /* ====== HEADER ====== */
  .wrap-h{
    display:flex;align-items:center;justify-content:space-between;
    padding:10px 12px;background:#fbfcfd;border-bottom:1px solid var(--border)
  }
  .wrap-h .title{margin:0;font-weight:700;color:#1c3651;font-size:22px;display:flex;gap:8px;align-items:center}
  .btn-add{
    display:inline-flex;align-items:center;gap:6px;height:30px;padding:0 8px;border-radius:2px;
    background:var(--blue);border:1px solid var(--blue-b);color:#fff;font-weight:700;font-size:12px;text-decoration:none
  }
  .btn-add i{font-size:13px}

  /* ====== FILTER BAR ====== */
  .filter{display:flex;gap:14px;align-items:center;flex-wrap:wrap;padding:12px;background:#fff;border-bottom:1px solid var(--border)}
  .inpg{display:flex;align-items:center;border:1px solid var(--border);border-radius:3px;overflow:hidden;background:#fff}
  .inpg .lab{min-width:128px;background:var(--head);border-right:1px solid var(--border);color:#2a425b;font-weight:700;font-size:13px;padding:7px 10px}
  .inpg select{border:0;outline:0;height:34px;min-width:250px;padding:6px 10px;font-size:13px}
  .right{margin-left:auto;display:flex;gap:8px}
  .btn{border:1px solid transparent;height:32px;padding:6px 10px;border-radius:2px;font-weight:700;font-size:13px;cursor:pointer}
  .btn-search{background:var(--green);border-color:var(--green-b);color:#fff;display:inline-flex;gap:6px;align-items:center}
  .btn-refresh{background:#e8eef6;border-color:var(--border);color:#314c67}

  /* ====== TABLE (1:1) ====== */
  .table-box{padding:0}
  table.tbl{width:100%;border-collapse:separate;border-spacing:0;table-layout:fixed}

  /* Fixed widths (SL→Action exactly like ref img) */
  .tbl col.sl{width:44px}
  .tbl col.name{width:170px}
  .tbl col.phone{width:150px}
  .tbl col.dob{width:130px}
  .tbl col.desig{width:135px}
  .tbl col.dept{width:130px}
  .tbl col.addr{width:230px}
  .tbl col.nid{width:150px}
  .tbl col.gender{width:90px}
  .tbl col.rel{width:115px}
  .tbl col.nat{width:120px}
  .tbl col.img{width:120px}
  .tbl col.act{width:110px}

  /* Header cells */
  .tbl thead th{
    background:var(--head);color:var(--text-head);font-size:13px;font-weight:800;
    padding:9px 10px;line-height:1.2;text-align:left;
    border-top:1px solid var(--border);border-bottom:1px solid var(--border);border-right:1px solid var(--border)
  }
  .tbl thead th:first-child{border-left:1px solid var(--border);text-align:center}
  .tbl thead th:nth-child(8),
  .tbl thead th:nth-child(9),
  .tbl thead th:nth-child(12),
  .tbl thead th:nth-child(13){text-align:center}

  /* Body cells */
  .tbl tbody td{
    background:#fff;color:var(--text);font-size:13px;line-height:1.2;
    padding:10px 10px;border-bottom:1px solid var(--border);border-right:1px solid var(--border);text-align:left
  }
  .tbl tbody td:first-child{border-left:1px solid var(--border);text-align:center}
  .tbl tbody td:nth-child(8),
  .tbl tbody td:nth-child(9),
  .tbl tbody td:nth-child(12),
  .tbl tbody td:nth-child(13){text-align:center}
  .tbl tbody tr:nth-child(odd) td{background:#fafcfe}
  .tbl tbody tr td{min-height:40px}

  /* Gender badge */
  .badge{display:inline-block;padding:3px 9px;border-radius:4px;font-weight:800;font-size:12px;border:1px solid transparent}
  .badge.male{background:#c8f0cf;border-color:#9fe0b0;color:#106c2b}
  .badge.na{background:#eef2f7;border-color:#d8e2ee;color:#4b5e77}

  /* Image thumb */
  .img-thumb{width:38px;height:30px;object-fit:cover;border:1px solid #dbe6f2;border-radius:2px;background:#fff}

  /* ====== ACTIONS & TOOLTIP ====== */
  .pill{width:26px;height:26px;border-radius:2px;border:1px solid transparent;display:inline-flex;align-items:center;justify-content:center;margin:0 2px;color:#fff;line-height:1}
  .pill.info{background:var(--info);border-color:var(--info-b);position:relative}
  .pill.edit{background:var(--edit);border-color:var(--edit-b)}
  .pill.del{background:var(--del);border-color:var(--del-b)}
  .pill i{font-size:12px}

  .tip{position:relative;display:inline-block}
  .tip-box{
    position:absolute;bottom:32px;left:50%;transform:translateX(-50%);
    min-width:260px;background:#fff;border:1px solid #d9e1eb;border-radius:4px;
    box-shadow:0 8px 24px rgba(0,0,0,.08);padding:10px 12px;color:#1f2a37;font-size:13px;
    text-align:left;z-index:20;display:none
  }
  .tip-box:after{content:"";position:absolute;left:50%;transform:translateX(-50%);bottom:-7px;border-width:7px;border-style:solid;border-color:#d9e1eb transparent transparent transparent}
  .tip-box:before{content:"";position:absolute;left:50%;transform:translateX(-50%);bottom:-6px;border-width:6px;border-style:solid;border-color:#fff transparent transparent transparent;z-index:2}
  .tip-head{font-weight:700;margin-bottom:8px;color:#2b4056;display:flex;gap:6px;align-items:center}
  .tip hr{border:0;border-top:1px solid #edf1f6;margin:8px 0}
  .pill.info:hover + .tip-box{display:block}

  /* ====== PAGINATION ====== */
  .footer{display:flex;justify-content:flex-end;gap:10px;padding:10px 12px;border-top:1px solid var(--border);background:#fbfcfd}
  .pager{display:flex;align-items:center;gap:8px}
  .pager a,.pager span{padding:6px 12px;border:1px solid var(--border);border-radius:4px;background:#fff;text-decoration:none;color:#1f2937;font-weight:700;font-size:13px}
  .pager .active{background:#1d4ed8;border-color:#1e40af;color:#fff}
  .pager .disabled{opacity:.6;pointer-events:none}
</style>
@endpush

@section('content')
<div class="wrap">
  {{-- Header --}}
  <div class="wrap-h">
    <h3 class="title"><i class="fa fa-list"></i> Employee List</h3>
    <a href="{{ route('employee.create') }}" class="btn-add"><i class="fa fa-plus"></i> Add Employee</a>
  </div>

  {{-- Filters --}}
  <form method="GET" action="{{ route('employee.index') }}" class="filter">
    <div class="inpg">
      <div class="lab">Designation</div>
      <select name="designation_id">
        <option value="">-Select Designation-</option>
        @foreach(($designations ?? []) as $d)
          <option value="{{ $d->id }}" @selected(request('designation_id')==$d->id)>{{ $d->name }}</option>
        @endforeach
      </select>
    </div>

    <div class="inpg">
      <div class="lab">Employee</div>
      <select name="emp_id">
        <option value="">-Select Employee-</option>
        @foreach(($employees ?? []) as $e)
          <option value="{{ $e->id }}" @selected(request('emp_id')==$e->id)>{{ $e->name }}</option>
        @endforeach
      </select>
    </div>

    <div class="right">
      <button class="btn btn-search" type="submit"><i class="fa fa-search"></i> Search</button>
      <a class="btn btn-refresh" href="{{ route('employee.index') }}"><i class="fa fa-refresh"></i></a>
    </div>
  </form>

  {{-- Table --}}
  <div class="table-box table-responsive">
    <table class="tbl">
      <colgroup>
        <col class="sl"><col class="name"><col class="phone"><col class="dob">
        <col class="desig"><col class="dept"><col class="addr"><col class="nid">
        <col class="gender"><col class="rel"><col class="nat"><col class="img"><col class="act">
      </colgroup>

      <thead>
        <tr>
          <th>SL</th>
          <th>Name</th>
          <th>Phone</th>
          <th>Date of Birth</th>
          <th>Designation</th>
          <th>Department</th>
          <th>Address</th>
          <th>NID</th>
          <th>Gender</th>
          <th>Religion</th>
          <th>Nationality</th>
          <th>Image</th>
          <th>Action</th>
        </tr>
      </thead>

      <tbody>
        @php $rows = $rows ?? collect(); @endphp
        @forelse($rows as $row)
          <tr>
            <td>{{ method_exists($rows,'firstItem') ? $rows->firstItem() + $loop->index : $loop->iteration }}</td>
            <td>{{ $row->name }}</td>
            <td>{{ $row->phone }}</td>
            <td>@if(!empty($row->date_of_birth)){{ \Illuminate\Support\Carbon::parse($row->date_of_birth)->format('Y-m-d') }}@endif</td>
            <td>{{ $row->designation_name ?? '' }}</td>
            <td>{{ $row->department_name  ?? '' }}</td>
            <td>{{ $row->address ?? '' }}</td>
            <td>{{ $row->nid ?? '' }}</td>
            <td>
              @php $g=strtolower($row->gender ?? ''); @endphp
              @if($g==='male') <span class="badge male">Male</span>
              @elseif($g==='female') <span class="badge male">Female</span>
              @else <span class="badge na">{{ $row->gender ?? 'N/A' }}</span>
              @endif
            </td>
            <td>{{ $row->religion ?? '' }}</td>
            <td>{{ $row->nationality ?? '' }}</td>
            <td>
              @if(!empty($row->image))
                <img class="img-thumb" src="{{ asset('storage/'.$row->image) }}" alt="{{ $row->name }}">
              @else
                Not available
              @endif
            </td>

            {{-- Action + Tooltip (DB-driven) --}}
            <td>
              <span class="tip">
                <a class="pill info" href="javascript:void(0)" title="Info"><i class="fa fa-info"></i></a>
                <div class="tip-box">
                  <div class="tip-head"><i class="fa fa-info-circle" style="color:#5aa447"></i> Log Information</div>
                  <div>Created By: <strong>{{ $row->created_by_name ?? '—' }}</strong></div>
                  <div>Created At : {{ $row->created_at ? \Illuminate\Support\Carbon::parse($row->created_at)->format('Y-m-d H:i:s') : '—' }}</div>
                  <hr>
                  <div>Updated By: <strong>{{ $row->updated_by_name ?? '—' }}</strong></div>
                  <div>Updated At : {{ $row->updated_at ? \Illuminate\Support\Carbon::parse($row->updated_at)->format('Y-m-d H:i:s') : '—' }}</div>
                </div>
              </span>

              <a class="pill edit" title="Edit" href="#"><i class="fa fa-pencil"></i></a>
              <form action="#" method="POST" style="display:inline" onsubmit="return confirm('Delete this employee?')">
                @csrf @method('DELETE')
                <button class="pill del" title="Delete" type="submit"><i class="fa fa-trash"></i></button>
              </form>
            </td>
          </tr>
        @empty
          <tr><td colspan="13" class="text-center" style="color:#6b7280;padding:14px 0;">No data found.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination --}}
  <div class="footer">
    @if(method_exists($rows,'links'))
      <div class="pager">
        @if($rows->onFirstPage())
          <span class="disabled">Previous</span>
        @else
          <a href="{{ $rows->previousPageUrl() }}">Previous</a>
        @endif

        <span class="active">{{ $rows->currentPage() }}</span>

        @if($rows->hasMorePages())
          <a href="{{ $rows->nextPageUrl() }}">Next</a>
        @else
          <span class="disabled">Next</span>
        @endif
      </div>
    @endif
  </div>
</div>
@endsection
