{{-- resources/views/employee/designations/index.blade.php --}}
@extends('layouts.app')
@section('title','Designation List')

@push('styles')
<style>
  :root{
    --border:#d9e3ef;
    --border-2:#cbd5e1;
    --thead:#f3f7fc;
    --thead-grad:linear-gradient(#f6f9fd,#eef3f9);
    --bg:#f4f7fb;
    --title:#195aa5;
  }
  .page{background:#fff;border:1px solid var(--border);border-radius:6px}
  .page-h{
    display:flex;align-items:center;justify-content:space-between;
    padding:10px 12px;border-bottom:1px solid var(--border);background:var(--thead-grad)
  }
  .page-h .ttl{margin:0;font-size:22px;font-weight:800;color:#0f172a;display:flex;gap:8px;align-items:center}
  .page-h .ttl i{color:var(--title)}
  .page-h .right{display:flex;gap:10px;align-items:center}
  .btn-add{
    display:inline-flex;gap:8px;align-items:center;
    background:#1d9bf0;color:#fff;border:1px solid #177ec4;border-radius:4px;
    padding:8px 12px;text-decoration:none;font-weight:700
  }
  .btn-add i{font-size:13px}
  .search{display:flex;gap:8px;align-items:center}
  .search label{color:#415a77;font-weight:700}
  .search input{
    height:32px;border:1px solid var(--border-2);border-radius:4px;padding:4px 8px;min-width:230px
  }

  .tbl{width:100%;border-collapse:separate;border-spacing:0}
  .tbl thead th{
    background:var(--thead-grad);border-bottom:1px solid var(--border);
    color:#195aa5;font-weight:800;padding:10px 12px;text-align:left
  }
  .tbl tbody td{
    padding:12px;border-bottom:1px solid var(--border);background:#fff
  }
  .tbl tbody tr:nth-child(odd) td{background:#fbfdff}
  .col-sl{width:70px;text-align:center}
  .col-act{width:150px;text-align:center}

  .pill{width:32px;height:28px;border-radius:4px;border:1px solid transparent;
        display:inline-flex;align-items:center;justify-content:center;color:#fff;cursor:pointer}
  .pill.info{background:#3ba3ef;border-color:#2a8bd2}
  .pill.edit{background:#2bc26b;border-color:#21a857}
  .pill.del {background:#f05252;border-color:#d33f3f}
  .pill i{font-size:13px}
  .act{display:flex;gap:8px;justify-content:center}

  .pager-wrap{
    display:flex;justify-content:flex-end;padding:10px 12px;background:#f7fafc;border-top:1px solid var(--border)
  }
  .pager a,.pager span{
    padding:6px 10px;border:1px solid #cbd5e1;border-radius:5px;background:#fff;
    text-decoration:none;color:#0f172a;font-weight:700;margin-left:6px
  }
  .pager .active{background:#1d9bf0;border-color:#177ec4;color:#fff}
</style>
@endpush

@section('content')
<div class="page">

  {{-- Header --}}
  <div class="page-h">
    <h3 class="ttl"><i class="fa fa-list"></i> Designation List</h3>

    <div class="right">
      <form class="search" method="GET" action="{{ route('employee.designations') }}">
        <label>Search:</label>
        <input type="text" name="q" value="{{ request('q') }}">
      </form>

      <a href="{{ route('employee.designations.create') }}" class="btn-add">
        <i class="fa fa-plus"></i> Add Designation
      </a>
    </div>
  </div>

  {{-- Table --}}
  <div class="table-responsive">
    <table class="tbl">
      <thead>
        <tr>
          <th class="col-sl">SL</th>
          <th>Designation Name</th>
          <th class="col-act">Action</th>
        </tr>
      </thead>
      <tbody>
        @php $rows = $rows ?? ($designations ?? collect()); @endphp

        @forelse($rows as $row)
          <tr>
            <td class="text-center">
              {{ method_exists($rows,'firstItem') ? $rows->firstItem() + $loop->index : $loop->iteration }}
            </td>
            <td>{{ $row->name ?? $row->designation_name ?? '' }}</td>
            <td class="col-act">
              <div class="act">
                <a class="pill info" title="View" href="#"><i class="fa fa-info"></i></a>
                <a class="pill edit" title="Edit" href="#"><i class="fa fa-pencil"></i></a>
                <form action="#" method="POST" style="display:inline" onsubmit="return confirm('Delete this designation?')">
                  @csrf @method('DELETE')
                  <button type="submit" class="pill del" title="Delete"><i class="fa fa-trash"></i></button>
                </form>
              </div>
            </td>
          </tr>
        @empty
          <tr><td colspan="3" class="text-center text-muted py-3">No data found.</td></tr>
        @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination --}}
  @if(method_exists($rows,'links'))
    <div class="pager-wrap">
      <div class="pager">
        @if($rows->onFirstPage())
          <span>Previous</span>
        @else
          <a href="{{ $rows->previousPageUrl() }}">Previous</a>
        @endif

        <span class="active">{{ $rows->currentPage() }}</span>

        @if($rows->hasMorePages())
          <a href="{{ $rows->nextPageUrl() }}">Next</a>
        @else
          <span>Next</span>
        @endif
      </div>
    </div>
  @endif
</div>
@endsection
