{{-- resources/views/employee/departments/index.blade.php --}}
@extends('layouts.app')
@section('title','Department List')

@push('styles')
<style>
  :root{
    --border:#d9e3ef;
    --head:#f6f9fd;
    --head-grad:linear-gradient(#f8fbff,#eef3f9);
  }

  .dept-card{background:#fff;border:1px solid var(--border);border-radius:6px;overflow:hidden}
  .dept-head{
    display:flex;align-items:center;justify-content:space-between;
    padding:10px 12px;background:var(--head-grad);border-bottom:1px solid var(--border)
  }
  .dept-title{margin:0;font-size:22px;font-weight:900;color:#14528c;display:flex;gap:10px;align-items:center}
  .top-right{display:flex;gap:10px;align-items:center}
  .search-input{height:32px;border:1px solid #cbd5e1;border-radius:4px;padding:6px 10px;min-width:220px}
  .btn-add{
    display:inline-flex;gap:8px;align-items:center;
    background:#2b82df;border:1px solid #1c72cf;color:#fff;
    padding:8px 12px;border-radius:4px;text-decoration:none;font-weight:800
  }

  .tbl-wrap{padding:0}
  table.tbl{width:100%;border-collapse:separate;border-spacing:0}
  table.tbl thead th{
    background:var(--head-grad);color:#14528c;font-weight:800;text-align:left;
    padding:10px 12px;border-bottom:1px solid var(--border)
  }
  table.tbl tbody td{padding:12px;border-top:1px solid #eef2f7}
  .col-sl{width:70px;text-align:left}
  .col-actions{width:180px;text-align:center}

  .actions{display:flex;gap:8px;justify-content:center}
  .pill{
    width:30px;height:30px;border-radius:6px;border:1px solid transparent;
    display:inline-flex;align-items:center;justify-content:center;color:#fff;cursor:pointer
  }
  .pill.info{background:#5aa9e6}
  .pill.edit{background:#28c76f}
  .pill.del{background:#ef4444}
  .pill i{font-size:13px}

  .foot{
    display:flex;align-items:center;justify-content:flex-end;gap:10px;
    padding:10px 12px;border-top:1px solid #eef2f7;background:#f8fafc
  }
  .pager{display:flex;gap:8px}
  .pager a,.pager span{
    padding:6px 10px;border:1px solid #cbd5e1;border-radius:6px;background:#fff;
    text-decoration:none;font-weight:700;color:#0f172a
  }
  .pager .active{background:#2b82df;border-color:#1c72cf;color:#fff}
</style>
@endpush

@section('content')
@php
  /** @var \Illuminate\Contracts\Pagination\LengthAwarePaginator|\Illuminate\Support\Collection $departments */
  $departments = $departments ?? ($rows ?? collect());
@endphp

<div class="dept-card">
  {{-- header --}}
  <div class="dept-head">
    <h3 class="dept-title"><i class="fa fa-list"></i> Department List</h3>
    <div class="top-right">
      <label style="font-weight:700;color:#14528c">Search:</label>
      <input class="search-input" type="text" placeholder="">
      <a href="{{ route('employee.departments.create') }}" class="btn-add">
        <i class="fa fa-plus"></i> Add Department
      </a>
    </div>
  </div>

  {{-- table --}}
  <div class="tbl-wrap">
    <table class="tbl">
      <thead>
        <tr>
          <th class="col-sl">SL</th>
          <th>Department Name</th>
          <th class="col-actions">Action</th>
        </tr>
      </thead>
      <tbody>
        @forelse($departments as $dept)
          <tr>
            <td>
              {{ method_exists($departments,'firstItem') ? $departments->firstItem() + $loop->index : $loop->iteration }}
            </td>
            <td>{{ $dept->name ?? $dept->department_name ?? '' }}</td>
            <td class="col-actions">
              <div class="actions">
                <a class="pill info" title="View" href="#"><i class="fa fa-info"></i></a>
                <a class="pill edit" title="Edit" href="#"><i class="fa fa-pencil"></i></a>
                <form action="#" method="POST" onsubmit="return confirm('Delete this department?')">
                  @csrf @method('DELETE')
                  <button type="submit" class="pill del" title="Delete"><i class="fa fa-trash"></i></button>
                </form>
              </div>
            </td>
          </tr>
        @empty
          <tr>
            <td colspan="3" class="text-center" style="color:#64748b;padding:24px">No data found.</td>
          </tr>
        @endforelse
      </tbody>
    </table>
  </div>

  {{-- footer / pagination --}}
  <div class="foot">
    @if(method_exists($departments,'links'))
      <div class="pager">
        @if($departments->onFirstPage())
          <span>Previous</span>
        @else
          <a href="{{ $departments->previousPageUrl() }}">Previous</a>
        @endif

        <span class="active">{{ $departments->currentPage() }}</span>

        @if($departments->hasMorePages())
          <a href="{{ $departments->nextPageUrl() }}">Next</a>
        @else
          <span>Next</span>
        @endif
      </div>
    @endif
  </div>
</div>
@endsection

