{{-- resources/views/employee/departments/create.blade.php --}}
@extends('layouts.app')
@section('title','Add Department')

@push('styles')
<style>
  :root{ --border:#d9e3ef; --head:#f6f9fd; --head-grad:linear-gradient(#f8fbff,#eef3f9); }
  .card{background:#fff;border:1px solid var(--border);border-radius:6px;overflow:hidden}
  .card-h{display:flex;align-items:center;justify-content:space-between;padding:10px 12px;background:var(--head-grad);border-bottom:1px solid var(--border)}
  .card-h .ttl{margin:0;font-size:18px;font-weight:800;color:#0f172a}
  .card-h .link{font-weight:700;color:#1d5fbf;text-decoration:none;display:inline-flex;gap:8px;align-items:center}
  .card-b{padding:18px 20px}
  .row{display:flex;align-items:center;gap:12px;margin-bottom:14px}
  .lab{min-width:180px;background:#eef2f7;border:1px solid var(--border);border-radius:4px;padding:8px 10px;font-weight:700;color:#334155}
  .in{flex:1;border:1px solid var(--border);border-radius:4px;height:38px;padding:8px 10px;width:100%}
  .actions{display:flex;gap:12px;justify-content:flex-end;margin-top:10px}
  .btn{display:inline-flex;gap:8px;align-items:center;border:1px solid transparent;padding:9px 14px;border-radius:4px;font-weight:800;text-decoration:none;cursor:pointer}
  .btn-save{background:#6fb36f;border-color:#5aa65a;color:#fff}
  .btn-reset{background:#9fb3c1;border-color:#8ea5b3;color:#fff}
  .btn i{font-size:13px}
</style>
@endpush

@section('content')
<div class="card">
  <div class="card-h">
    <h4 class="ttl">Add Department</h4>
    <a class="link" href="{{ route('employee.departments') }}">
      <i class="fa fa-list"></i> Department List
    </a>
  </div>

  <div class="card-b">
    <form method="POST" action="{{ route('employee.departments.store') }}">
      @csrf
      <div class="row">
        <div class="lab">Department Name <span style="color:#e11d48">*</span></div>
        <input class="in" type="text" name="name" placeholder="Enter The Department Name" value="{{ old('name') }}">
      </div>

      <div class="actions">
        <button type="submit" class="btn btn-save"><i class="fa fa-save"></i> Save</button>
        <button type="reset"  class="btn btn-reset"><i class="fa fa-refresh"></i> Reset</button>
      </div>
    </form>
  </div>
</div>
@endsection
