﻿@extends('layouts.app')
@section('title','Add New Employee')

@push('styles')
<style>
/* ============ SCOPE ============ */
.empx *{ box-sizing:border-box; font-size:14px }
.empx{ margin-top:8px }

/* title bar */
.empx .bar{
  display:flex; align-items:center; justify-content:space-between;
  padding:10px 14px; border:1px solid #d7dde6; border-bottom:0; border-radius:3px 3px 0 0;
  background:#f6f8fb;
}
.empx .ttl{ display:flex; align-items:center; gap:10px; font-size:20px; font-weight:700; color:#2d3a4b }
.empx .btn-list{
  height:34px; padding:.4rem .75rem; border-radius:3px;
  background:#5aa0d8; border:1px solid #5297ce; color:#fff; display:inline-flex; gap:6px; align-items:center;
}
.empx .btn-list i{ font-size:13px }

/* frame */
.empx .frame{ border:1px solid #d7dde6; border-radius:0 0 3px 3px; background:#fff; padding:18px 14px }

/* grid (two columns) */
.empx .row{ display:flex; gap:20px; margin-bottom:12px }
.empx .col{ flex:1 1 0 }

/* field row: label (fixed) + control (flex) — table-like 1:1 */
.empx .frow{ display:flex; align-items:center }
.empx .lbl{
  width:110px; min-width:110px; height:36px;
  border:1px solid #dfe5ec; border-right:0; border-radius:3px 0 0 3px;
  background:#f7f9fc; color:#394b63; font-weight:600;
  display:flex; align-items:center; padding:0 .75rem;
}
.empx .ctrl{
  flex:1 1 auto; height:36px; border:1px solid #dfe5ec; border-radius:0 3px 3px 0;
  display:flex; align-items:center; background:#fff;
}
.empx .ctrl input,
.empx .ctrl select,
.empx .ctrl textarea{
  border:0; outline:0; width:100%; height:34px; padding:.35rem .6rem; background:transparent;
}
.empx .ctrl textarea{ height:36px; resize:vertical }

/* choose button (right small) */
.empx .choose{
  height:30px; padding:.2rem .6rem; margin-right:6px; border-radius:3px;
  background:#5aa0d8; border:1px solid #5297ce; color:#fff
}

/* footer buttons */
.empx .actions{
  display:flex; justify-content:flex-end; gap:10px; margin-top:8px
}
.empx .btn-save{
  background:#69a95e; border:1px solid #5f9956; color:#fff; height:36px; padding:.45rem .9rem; border-radius:3px; display:inline-flex; gap:6px; align-items:center;
}
.empx .btn-reset{
  background:#e9eef3; border:1px solid #d9e2ea; color:#3f4a59; height:36px; padding:.45rem .9rem; border-radius:3px; display:inline-flex; gap:6px; align-items:center;
}
.empx .btn-save i,.empx .btn-reset i{ font-size:13px }
</style>
@endpush

@section('content')
<div class="empx">
  {{-- title bar --}}
  <div class="bar">
    <div class="ttl"><i class="fa fa-gear"></i> Add New Employee</div>

    @php
      $listUrl = Route::has('employees.index')
        ? route('employees.index')
        : (Route::has('employee.index') ? route('employee.index') : '#');
    @endphp
    <a href="{{ $listUrl }}" class="btn-list"><i class="fa fa-list"></i> Employee List</a>
  </div>

  {{-- frame --}}
  <div class="frame">
    @php
      $storeUrl = Route::has('employees.store')
        ? route('employees.store')
        : (Route::has('employee.store') ? route('employee.store') : '#');
    @endphp

    <form action="{{ $storeUrl }}" method="POST" enctype="multipart/form-data">
      @csrf

      {{-- Row 1: Name | Phone --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">Name*</div>
            <div class="ctrl"><input type="text" name="name" placeholder="Enter the Employee Name" value="{{ old('name') }}"></div>
          </div>
        </div>
        <div class="col">
          <div class="frow">
            <div class="lbl">Phone *</div>
            <div class="ctrl"><input type="text" name="phone" placeholder="Enter the phone Number" value="{{ old('phone') }}"></div>
          </div>
        </div>
      </div>

      {{-- Row 2: DOB | Designation --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">Date of Birth</div>
            <div class="ctrl"><input type="text" name="dob" placeholder="Enter the  date of birth(Y-m-d)" value="{{ old('dob') }}"></div>
          </div>
        </div>
        <div class="col">
          <div class="frow">
            <div class="lbl">Designation*</div>
            <div class="ctrl">
              <select name="designation_id">
                <option value="">.......Selected Designation......</option>
                @foreach($designations ?? [] as $d)
                  <option value="{{ $d->id }}" @selected(old('designation_id')==$d->id)>{{ $d->name }}</option>
                @endforeach
              </select>
            </div>
          </div>
        </div>
      </div>

      {{-- Row 3: Department | Address --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">Department *</div>
            <div class="ctrl">
              <select name="department_id">
                <option value="">.......Selected Department......</option>
                @foreach($departments ?? [] as $d)
                  <option value="{{ $d->id }}" @selected(old('department_id')==$d->id)>{{ $d->name }}</option>
                @endforeach
              </select>
            </div>
          </div>
        </div>
        <div class="col">
          <div class="frow">
            <div class="lbl">Address *</div>
            <div class="ctrl"><input type="text" name="address" placeholder="Enter the Address" value="{{ old('address') }}"></div>
          </div>
        </div>
      </div>

      {{-- Row 4: NID | Gender --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">NID</div>
            <div class="ctrl"><input type="text" name="nid" placeholder="NID" value="{{ old('nid') }}"></div>
          </div>
        </div>
        <div class="col">
          <div class="frow">
            <div class="lbl">Gender</div>
            <div class="ctrl">
              <select name="gender">
                <option value="Male"   @selected(old('gender','Male')=='Male')>Male</option>
                <option value="Female" @selected(old('gender')=='Female')>Female</option>
                <option value="Other"  @selected(old('gender')=='Other')>Other</option>
              </select>
            </div>
          </div>
        </div>
      </div>

      {{-- Row 5: Religion | Nationality --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">Religion</div>
            <div class="ctrl"><input type="text" name="religion" placeholder="Religion" value="{{ old('religion') }}"></div>
          </div>
        </div>
        <div class="col">
          <div class="frow">
            <div class="lbl">Nationality</div>
            <div class="ctrl"><input type="text" name="nationality" placeholder="Nationality" value="{{ old('nationality') }}"></div>
          </div>
        </div>
      </div>

      {{-- Row 6: Image (full width left col to keep “Choose” at end like screenshot) --}}
      <div class="row">
        <div class="col">
          <div class="frow">
            <div class="lbl">Image</div>
            <div class="ctrl" style="justify-content:space-between;">
              <span style="padding-left:.6rem; color:#6b7280;">No File …</span>
              <label class="choose">
                <input type="file" name="image" style="display:none" onchange="this.previousElementSibling.textContent = this.files?.[0]?.name || 'No File …'">
                Choose
              </label>
            </div>
          </div>
        </div>
        <div class="col"><!-- empty to mimic screenshot spacing --></div>
      </div>

      {{-- footer buttons --}}
      <div class="actions">
        <button type="submit" class="btn-save"><i class="fa fa-save"></i> Save</button>
        <button type="reset" class="btn-reset"><i class="fa fa-refresh"></i> Reset</button>
      </div>
    </form>
  </div>
</div>
@endsection

