﻿@extends('layouts.app')
@section('title','Dashboard')

@push('styles')
<style>
  :root{
    /* কার্ড/টেক্সট/বর্ডার কালার */
    --card:#fff;
    --border:#e5e7eb;
    --text:#111;
    --muted:#6b7280;

    /* হিরো ব্যাকগ্রাউন্ড (গ্রেডিয়েন্ট) */
    --brand-1:#2D82F3;
    --brand-2:#1E3B78;

    /* নীল ব্যাকগ্রাউন্ডটা নিচে একটু ঢুকবে */
    --hero-overlap: 20px;

    /* ✅ Filter বাটন আর KPI গ্রিডের মাঝের গ্যাপ (px) */
    --filter-kpi-gap: 24px;
  }

  /* ===== HERO (উপরে নীল বার) ===== */
  .dash-hero{
    /* পেজের ডিফল্ট প্যাডিংয়ের সাথে মিলিয়ে নিলাম */
    margin:-16px -16px calc(var(--hero-overlap) * -1);
    /* নিচে কার্ড শুরুর আগে গ্যাপ বেশি দিতে padding-bottom বাড়ানো */
    padding:16px 16px calc(22px + var(--hero-overlap));
    background:linear-gradient(135deg,var(--brand-1) 0%, var(--brand-2) 100%);
    color:#fff;
    border-radius:0;
  }

  /* হেডার লাইন (Welcome + Filter) */
  .dash-hero .head{
    display:flex;
    align-items:flex-start;         /* Filter বাটনটা Welcome লাইনের থেকে সামান্য নিচে */
    justify-content:space-between;
    gap:16px;
    margin-bottom:var(--filter-kpi-gap); /* ✅ এখানে দিয়েই KPI-র সাথে গ্যাপ তৈরি */
  }

  .dash-hero h2{
    margin:0;
    font-weight:900;
    font-size:20px;                 /* কমপ্যাক্ট সাইজ */
    letter-spacing:.2px;
    white-space:nowrap;
    overflow:hidden;
    text-overflow:ellipsis;
  }

  /* ===== Filter (ডান পাশে) ===== */
  .filter{
    position:relative;
    margin-left:auto;
    margin-top:26px;                /* বাটনটাকে Welcome থেকে একটু নিচে নামানো */
  }
  .filter-btn{
    display:inline-flex;align-items:center;gap:8px;
    height:36px; padding:0 14px;
    background:#1e63d6; color:#fff;
    border:0; cursor:pointer;
    border-radius:8px; font-weight:800;
    box-shadow:0 2px 0 rgba(0,0,0,.06);
  }
  .filter-btn .fa-calendar-day{opacity:.95}
  .filter-btn .fa-caret-down{margin-left:2px}

  .filter-menu{
    position:absolute; right:0; top:calc(100% + 6px); z-index:20;
    background:#fff; color:#111; border:1px solid var(--border);
    border-radius:8px; min-width:190px; padding:6px 0; display:none;
    box-shadow:0 14px 32px rgba(0,0,0,.15);
  }
  .filter.open .filter-menu{display:block}
  .filter-menu button{
    width:100%; text-align:left; background:transparent; border:0; cursor:pointer;
    padding:9px 12px; font-weight:600; color:#111827; font-size:13px;
  }
  .filter-menu button:hover{background:#eef4ff; color:#1e3a8a}
  .filter-menu button.active{background:#1e63d6; color:#fff}

  /* মোবাইলে Filter নিচে গেলে ফুল-উইডথ */
  @media (max-width:520px){
    .dash-hero .head{ flex-wrap:wrap }
    .filter{ width:100%; margin-top:8px }
    .filter-btn{ width:100%; justify-content:space-between }
  }

  /* ===== KPI গ্রিড (৪ কলাম) ===== */
  .kpi-grid-hero{
    display:grid; gap:14px;
    grid-template-columns:repeat(4,minmax(0,1fr));
  }
  .kpi-grid{
    display:grid; gap:14px;
    grid-template-columns:repeat(4,minmax(0,1fr));
    margin-bottom:14px; position:relative; z-index:1;
  }

  /* রেসপনসিভ কলাম ভাঙ্গা */
  @media (max-width:1280px){
    .kpi-grid-hero,.kpi-grid{grid-template-columns:repeat(3,minmax(0,1fr))}
  }
  @media (max-width:1024px){
    .kpi-grid-hero,.kpi-grid{grid-template-columns:repeat(2,minmax(0,1fr))}
  }
  @media (max-width:640px){
    .kpi-grid-hero,.kpi-grid{grid-template-columns:repeat(1,minmax(0,1fr))}
  }

  /* ===== KPI কার্ড স্টাইল ===== */
  .kpi{
    background:var(--card);
    border:1px solid var(--border);
    border-radius:12px;
    padding:14px;
    display:flex; align-items:center; gap:12px;
    position:relative; overflow:hidden;
  }
  .kpi-ico{
    width:46px; height:46px; border-radius:12px;
    display:flex; align-items:center; justify-content:center;
    color:#fff; font-size:18px;
  }
  .kpi h4{margin:0; font-size:13px; color:var(--muted); font-weight:800}
  .kpi .val{font-size:22px; font-weight:900; color:var(--text); margin-top:4px}

  /* টপ-রাইটে শ্যাডো/কোয়ার্টার-সার্কেল ইফেক্ট */
  .kpi:after{
    content:""; position:absolute; right:-32px; top:-32px;
    width:120px; height:120px; border-radius:999px;
    background:radial-gradient(closest-side, #eef2f7 60%, transparent 61%);
    opacity:1;
  }

  /* ===== চার্ট প্যানেল ===== */
  .charts-wrap{display:grid; gap:14px; grid-template-columns:1fr 380px}
  @media (max-width:1200px){.charts-wrap{grid-template-columns:1fr}}
  .panel{background:#fff; border:1px solid var(--border); border-radius:12px; padding:14px}
  .panel h3{margin:0 0 10px; font-size:16px; font-weight:800; color:#111}
  .right-stack{display:grid; gap:14px}
  .chart-box{position:relative; height:360px; max-height:360px}
  .chart-box.tall{height:440px; max-height:440px}
  .chart-box.sm{height:300px; max-height:300px}
  .chart-box canvas{position:absolute; inset:0; width:100% !important; height:100% !important}
</style>
@endpush
@section('content')
@php
  $userName = auth()->user()->name ?? 'System Admin';

  $kpis = $kpis ?? [
    ['label'=>'Total Finish Products','value'=>0,'icon'=>'fa-box-archive','bg'=>'#ef4444'],
    ['label'=>'Total Raw Purchase','value'=>0,'icon'=>'fa-cart-flatbed','bg'=>'#8b5cf6'],
    ['label'=>'Total Sales','value'=>0,'icon'=>'fa-scale-balanced','bg'=>'#22c55e'],
    ['label'=>'Total Net Sales','value'=>0,'icon'=>'fa-file-invoice-dollar','bg'=>'#10b981'],
    ['label'=>'Total Due','value'=>0,'icon'=>'fa-file-invoice','bg'=>'#f59e0b'],
    ['label'=>'Today Due Collection','value'=>0,'icon'=>'fa-receipt','bg'=>'#f59e0b'],
    ['label'=>'Today Purchase','value'=>0,'icon'=>'fa-money-bill-transfer','bg'=>'#06b6d4'],
    ['label'=>'Today Purchase Due','value'=>0,'icon'=>'fa-circle-exclamation','bg'=>'#fb923c'],
    ['label'=>'Today Expense','value'=>0,'icon'=>'fa-wallet','bg'=>'#ef4444'],
    ['label'=>'Total Sales Return','value'=>0,'icon'=>'fa-rotate-left','bg'=>'#ef4444'],
    ['label'=>'Today Sales','value'=>0,'icon'=>'fa-cart-shopping','bg'=>'#0ea5a4'],
    ['label'=>'Today Net Sales','value'=>0,'icon'=>'fa-file-invoice-dollar','bg'=>'#22c55e'],
  ];

  $kpisTop  = array_slice($kpis, 0, 4);
  $kpisRest = array_slice($kpis, 4);

  $days      = $days ?? range(1,31);
  $sales     = $sales  ?? array_fill(0, count($days), 0);
  $orders    = $orders ?? array_fill(0, count($days), 0);
  $annualByMonth = $annualByMonth ?? array_fill(0, 12, 0);
  $yearSales = $yearSales ?? 0;  $yearOrders = $yearOrders ?? 0;
@endphp

<div class="dash-hero">
  <div class="head">
    <h2>Welcome {{ $userName }},</h2>

    <div class="filter" id="dateFilter">
      <button class="filter-btn" type="button">
        <i class="fa-solid fa-calendar-day"></i> Filter by date
        <i class="fa-solid fa-caret-down"></i>
      </button>
      <div class="filter-menu">
        @foreach ([
          'Today','Yesterday','Last 7 Days','Last 30 Days','This Month','Last Month',
          'This month last year','This Year','Last Year','Current financial year',
          'Last financial year','Custom Range'
        ] as $i => $opt)
          <button type="button" data-range="{{ $opt }}" class="{{ $i===0?'active':'' }}">{{ $opt }}</button>
        @endforeach
      </div>
    </div>
  </div>
  <div class="kpi-grid-hero">
    @foreach($kpisTop as $k)
      <div class="kpi">
        <div class="kpi-ico" style="background:{{ $k['bg'] }}"><i class="fa-solid {{ $k['icon'] }}"></i></div>
        <div>
          <h4>{{ $k['label'] }}</h4>
          <div class="val">{{ number_format($k['value']) }}</div>
        </div>
      </div>
    @endforeach
  </div>
</div>

@if(count($kpisRest))
  <div class="kpi-grid">
    @foreach($kpisRest as $k)
      <div class="kpi">
        <div class="kpi-ico" style="background:{{ $k['bg'] }}"><i class="fa-solid {{ $k['icon'] }}"></i></div>
        <div>
          <h4>{{ $k['label'] }}</h4>
          <div class="val">{{ number_format($k['value']) }}</div>
        </div>
      </div>
    @endforeach
  </div>
@endif

<div class="charts-wrap">
  <div class="panel">
    <h3>Monthly Sales & Orders</h3>
    <div class="chart-box tall"><canvas id="areaChart"></canvas></div>
  </div>

  <div class="right-stack">
    <div class="panel">
      <h3>Annual Report</h3>
      <div class="chart-box sm"><canvas id="annualPie1"></canvas></div>
    </div>
    <div class="panel">
      <h3>Annual Sales & Orders</h3>
      <div class="chart-box sm"><canvas id="annualPie2"></canvas></div>
    </div>
  </div>
</div>
@endsection

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js@4.4.1/dist/chart.umd.min.js"></script>
<script>
  (function(){
    const root = document.getElementById('dateFilter');
    const btn  = root?.querySelector('.filter-btn');
    const items = root?.querySelectorAll('.filter-menu button') || [];

    btn?.addEventListener('click', e => { e.stopPropagation(); root.classList.toggle('open'); });
    document.addEventListener('click', e => { if(root && !root.contains(e.target)) root.classList.remove('open'); });

    items.forEach(b=>{
      b.addEventListener('click', () => {
        items.forEach(x=>x.classList.remove('active'));
        b.classList.add('active');
        root.classList.remove('open');
        // এখানে চাইলে আপনার Ajax/redirect বসান।
      });
    });
  })();

  const days   = @json(array_map('strval',$days));
  const sales  = @json($sales);
  const orders = @json($orders);
  const total  = sales.map((v,i)=> (Number(v)||0) + (Number(orders[i])||0));

  new Chart(document.getElementById('areaChart'),{
    type:'line',
    data:{ labels:days,
      datasets:[{
        label:'Total (Sales + Orders)', data: total, fill:'start', tension:.35, pointRadius:0, borderWidth:2
      },{
        label:'Sales', data: sales, tension:.35, pointRadius:0, borderWidth:1
      },{
        label:'Orders', data: orders, tension:.35, pointRadius:0, borderWidth:1
      }]
    },
    options:{ responsive:true, maintainAspectRatio:false, plugins:{legend:{position:'top'}}, scales:{ y:{ beginAtZero:true, ticks:{ precision:0 } } } }
  });

  const months = ['Jan','Feb','Mar','Apr','May','Jun','Jul','Aug','Sep','Oct','Nov','Dec'];
  const monthly = @json($annualByMonth);
  new Chart(document.getElementById('annualPie1'),{
    type:'pie',
    data:{ labels:months, datasets:[{ data: monthly }] },
    options:{ responsive:true, maintainAspectRatio:false, plugins:{legend:{position:'bottom'}} }
  });

  const yearSales  = Number(@json($yearSales))  || 0;
  const yearOrders = Number(@json($yearOrders)) || 0;
  new Chart(document.getElementById('annualPie2'),{
    type:'pie',
    data:{ labels:['Sales','Orders'], datasets:[{ data:[yearSales,yearOrders] }] },
    options:{ responsive:true, maintainAspectRatio:false, plugins:{legend:{position:'bottom'}} }
  });
</script>
@endpush

