﻿@extends('layouts.app')
@section('title','Bag Exchange List')

@push('styles')
<style>
/* ======= scoped so it won't fight your theme ======= */
.bx-index * { box-sizing:border-box; font-size:14px }
.bx-index .panel { border:1px solid #e3e8ee; background:#fff; border-radius:4px }
.bx-index .panel-hd{
  display:flex; align-items:center; justify-content:space-between;
  padding:10px 14px; border-bottom:1px solid #e9edf3; background:#f9fbfd;
}
.bx-index .title{ font-weight:700; color:#2c3e50; display:flex; gap:8px; align-items:center }
.bx-index .btn-add{
  display:inline-flex; align-items:center; gap:6px;
  background:#2da5ff; border:1px solid #2796ea; color:#fff;
  height:32px; padding:0 12px; border-radius:4px; text-decoration:none;
}
.bx-index .table-wrap{ padding:10px 12px }
.bx-index table{ width:100%; border-collapse:collapse }
.bx-index th, .bx-index td{ border:1px solid #e8eef5; padding:8px 10px; white-space:nowrap }
.bx-index thead th{ background:#f3f6fb; color:#425466; font-weight:700 }
.bx-index tbody td{ background:#fff; color:#27364b }
.bx-index .text-end{ text-align:right }
.bx-index .actions{ display:flex; gap:6px; justify-content:center }
.bx-index .btn-icon{
  width:30px; height:30px; display:inline-flex; align-items:center; justify-content:center;
  border:1px solid transparent; border-radius:4px; cursor:pointer; text-decoration:none; color:#fff;
}
.bx-index .btn-view{ background:#59a5d8; border-color:#4d97c8 }
.bx-index .btn-edit{ background:#66c18c; border-color:#56b27c }
.bx-index .btn-del { background:#e06e6e; border-color:#cf5f5f }
</style>
@endpush

@section('content')
<div class="bx-index">
  <div class="panel">
    <div class="panel-hd">
      <div class="title"><i class="fa fa-list"></i> Bag Exchange List</div>
      <a href="{{ route('bag_exchange.create') }}" class="btn-add">
        <i class="fa fa-plus"></i> Add Bag Exchange
      </a>
    </div>

    <div class="table-wrap">
      <div class="table-responsive">
        <table>
          <thead>
            <tr>
              <th style="width:60px">SL</th>
              <th style="width:120px">Date</th>
              <th>Invoice No</th>
              <th>Warehouse</th>
              <th>Product</th>
              <th class="text-end">Quantity</th>
              <th class="text-end">Bag</th>
              <th>Exchange Warehouse</th>
              <th>Exchange Product</th>
              <th class="text-end">Exchange Bag</th>
              <th style="width:140px; text-align:center">Action</th>
            </tr>
          </thead>
          <tbody>
            @forelse($rows as $i => $r)
              <tr>
                <td>{{ ($rows->firstItem() ?? 1) + $i }}</td>
                <td>{{ \Illuminate\Support\Carbon::parse($r->date)->format('Y-m-d') }}</td>
                <td>{{ $r->invoice_no ?? $r->voucher_no ?? $r->reference ?? '—' }}</td>

                {{-- Adjust these to your actual relationships/columns --}}
                <td>{{ optional($r->warehouse)->name ?? $r->warehouse_name ?? '—' }}</td>
                <td>{{ optional($r->product)->name ?? $r->product_name ?? '—' }}</td>

                <td class="text-end">{{ number_format((float)($r->quantity ?? $r->qty ?? 0), 2) }}</td>
                <td class="text-end">{{ (int)($r->bag ?? 0) }}</td>

                <td>{{ optional($r->exchangeWarehouse)->name ?? $r->exchange_warehouse_name ?? '—' }}</td>
                <td>{{ optional($r->exchangeProduct)->name ?? $r->exchange_product_name ?? '—' }}</td>
                <td class="text-end">{{ (int)($r->exchange_bag ?? 0) }}</td>

                <td class="actions">
                  <a class="btn-icon btn-view"  href="{{ route('bag_exchange.show',  $r->id) }}" title="View"><i class="fa fa-info"></i></a>
                  <a class="btn-icon btn-edit"  href="{{ route('bag_exchange.edit',  $r->id) }}" title="Edit"><i class="fa fa-edit"></i></a>
                  <form method="POST" action="{{ route('bag_exchange.destroy',$r->id) }}" onsubmit="return confirm('Delete this record?')">
                    @csrf @method('DELETE')
                    <button type="submit" class="btn-icon btn-del" title="Delete"><i class="fa fa-trash"></i></button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="11" class="text-center" style="padding:18px; color:#748298">No data found</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      @if(method_exists($rows,'links'))
        <div class="mt-2">
          {{ $rows->appends(request()->query())->links() }}
        </div>
      @endif
    </div>
  </div>
</div>
@endsection

