﻿@extends('layouts.app')

@section('title','Create Bag Exchange')

@push('styles')
<style>
  /* ------- page card ------- */
  .bx-card{background:#fff;border:1px solid #dfe3ea;border-radius:6px;overflow:hidden}
  .bx-hd{display:flex;align-items:center;justify-content:space-between;
         padding:10px 12px;background:#f7f9fc;border-bottom:1px solid #e7ecf3}
  .bx-hd h3{margin:0;font-size:18px;color:#2a3954;font-weight:700;display:flex;gap:8px;align-items:center}
  .bx-hd h3 i{color:#2f80ed}
  .bx-body{padding:14px}

  /* ------- fields ------- */
  .bx-row{display:grid;grid-template-columns:1fr 1fr;gap:16px}
  .bx-field{display:flex;align-items:center;gap:10px}
  .bx-label{flex:0 0 175px;background:#f3f5f9;border:1px solid #e3e7ee;
            color:#2a3954;font-weight:600;border-radius:4px;padding:8px 10px}
  .bx-ctl{flex:1}
  .bx-ctl input[type="text"],
  .bx-ctl input[type="number"],
  .bx-ctl input[type="date"],
  .bx-ctl select{
      width:100%;height:36px;border:1px solid #d7dbe3;border-radius:4px;
      padding:6px 10px;background:#fff;outline:none
  }
  .bx-ctl input[readonly]{background:#f3f5f9}
  .bx-note{color:#8a94a6;font-size:13px;margin-left:12px}

  /* ------- footer ------- */
  .bx-footer{display:flex;gap:10px;justify-content:flex-end;margin-top:18px}
  .btn{height:36px;border-radius:4px;border:0;cursor:pointer;padding:0 16px;font-weight:700}
  .btn-green{background:#2fb579;color:#fff}
  .btn-gray{background:#eaeef4;color:#2a3954}
  .btn-green i,.btn-gray i{margin-right:6px}

  .link-list{display:inline-flex;align-items:center;gap:8px;font-weight:700;
             color:#2a6fdc;text-decoration:none}
  .link-list i{color:#2a6fdc}

  /* responsive */
  @media (max-width: 1100px){ .bx-row{grid-template-columns:1fr} .bx-label{flex:0 0 160px} }
  @media (max-width: 640px){ .bx-label{flex:0 0 140px} }
</style>
@endpush

@section('content')
<form action="{{ route('bag_exchange.store') }}" method="POST" autocomplete="off">
  @csrf

  <div class="bx-card">
    <div class="bx-hd">
      <h3><i class="fa-solid fa-arrows-rotate"></i> Create Bag Exchange</h3>

      <a href="{{ route('bag_exchange.index') }}" class="link-list">
        <i class="fa-solid fa-table-list"></i> Bag Exchange List
      </a>
    </div>

    <div class="bx-body">

      {{-- Row 1 --}}
      <div class="bx-row">

        {{-- Warehouse Name --}}
        <div class="bx-field">
          <div class="bx-label">Warehouse Name*</div>
          <div class="bx-ctl">
            <select name="warehouse_id" required>
              <option value="">-Select Warehouse-</option>
              @foreach($warehouses ?? [] as $w)
                <option value="{{ $w->id }}" @selected(old('warehouse_id')==$w->id)>{{ $w->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Date --}}
        <div class="bx-field">
          <div class="bx-label">Date</div>
          <div class="bx-ctl">
            <input type="date" name="date" value="{{ old('date', now()->toDateString()) }}">
          </div>
        </div>

        {{-- Bag Ware Name --}}
        <div class="bx-field">
          <div class="bx-label">Bag Ware Name*</div>
          <div class="bx-ctl">
            <select name="bag_warehouse_id" required>
              <option value="">-Select Warehouse-</option>
              @foreach(($bagWarehouses ?? $warehouses ?? []) as $bw)
                <option value="{{ $bw->id }}" @selected(old('bag_warehouse_id')==$bw->id)>{{ $bw->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Exchange Warehouse Name --}}
        <div class="bx-field">
          <div class="bx-label">Ex. Warehouse Name*</div>
          <div class="bx-ctl">
            <select name="ex_warehouse_id" required>
              <option value="">-Select Exchange Warehouse-</option>
              @foreach($warehouses ?? [] as $w)
                <option value="{{ $w->id }}" @selected(old('ex_warehouse_id')==$w->id)>{{ $w->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Product --}}
        <div class="bx-field">
          <div class="bx-label">Product*</div>
          <div class="bx-ctl">
            <select name="product_id" id="product_id" required>
              <option value="">-Select Product -</option>
              @foreach($products ?? [] as $p)
                <option value="{{ $p->id }}" @selected(old('product_id')==$p->id)>{{ $p->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Exchanged Product --}}
        <div class="bx-field">
          <div class="bx-label">Ex. Product*</div>
          <div class="bx-ctl">
            <select name="ex_product_id" required>
              <option value="">-Select Product -</option>
              @foreach($products ?? [] as $p)
                <option value="{{ $p->id }}" @selected(old('ex_product_id')==$p->id)>{{ $p->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Finish Bag --}}
        <div class="bx-field">
          <div class="bx-label">Finish Bag *</div>
          <div class="bx-ctl">
            <select name="finish_bag_id" required>
              <option value="">-Select Bag -</option>
              @foreach($finishBags ?? [] as $b)
                <option value="{{ $b->id }}" @selected(old('finish_bag_id')==$b->id)>{{ $b->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Exchanged Finish Bag --}}
        <div class="bx-field">
          <div class="bx-label">Exchanged Finish Bag *</div>
          <div class="bx-ctl">
            <select name="ex_finish_bag_id" required>
              <option value="">-Select Product -</option>
              @foreach($finishBags ?? [] as $b)
                <option value="{{ $b->id }}" @selected(old('ex_finish_bag_id')==$b->id)>{{ $b->name }}</option>
              @endforeach
            </select>
          </div>
        </div>

        {{-- Product Stock (kg) --}}
        <div class="bx-field">
          <div class="bx-label">Product Stock (kg)</div>
          <div class="bx-ctl">
            <input type="number" step="0.001" name="product_stock_kg" id="product_stock_kg"
                   value="{{ old('product_stock_kg') }}" readonly placeholder="Stock Total Kg">
          </div>
        </div>

        {{-- Exchange Total Kg --}}
        <div class="bx-field">
          <div class="bx-label">Total Kg*</div>
          <div class="bx-ctl">
            <input type="number" step="0.001" name="total_kg" id="total_kg"
                   value="{{ old('total_kg') }}" required placeholder="Exchange Total Kg">
          </div>
        </div>

      </div><!--/bx-row-->

      @if ($errors->any())
        <div class="bx-note" style="color:#d13b3b;font-weight:600;">
          @foreach ($errors->all() as $err)
            <div>• {{ $err }}</div>
          @endforeach
        </div>
      @endif

      <div class="bx-footer">
        <button type="submit" class="btn btn-green"><i class="fa-regular fa-floppy-disk"></i> Save</button>
        <button type="reset" class="btn btn-gray"><i class="fa-solid fa-rotate"></i> Reset</button>
      </div>
    </div>
  </div>
</form>
@endsection

@push('scripts')
<script>
  // Example hook-ups (replace with real AJAX if you fetch live stock)
  document.getElementById('product_id')?.addEventListener('change', function () {
    // TODO: load stock for selected product+warehouse via AJAX.
    // For now we just clear it:
    document.getElementById('product_stock_kg').value = '';
  });
</script>
@endpush
