@extends('layouts.app')

@section('title','Change Password')

@section('content')
  @if (session('status'))
    <div style="padding:10px;background:#e7f5ff;border:1px solid #b6e0fe;margin-bottom:12px;">
      {{ session('status') }}
    </div>
  @endif

  <form method="POST" action="{{ route('password.update') }}" style="max-width:420px;">
    @csrf
    @method('PUT')

    <div style="margin-bottom:12px;">
      <label>Current password</label>
      <input type="password" name="current_password" class="form-control" required style="width:100%;padding:10px;border:1px solid #ddd;border-radius:6px;">
      @error('current_password')<div style="color:#dc2626">{{ $message }}</div>@enderror
    </div>

    <div style="margin-bottom:12px;">
      <label>New password</label>
      <input type="password" name="password" class="form-control" required style="width:100%;padding:10px;border:1px solid #ddd;border-radius:6px;">
      @error('password')<div style="color:#dc2626">{{ $message }}</div>@enderror
    </div>

    <div style="margin-bottom:16px;">
      <label>Confirm new password</label>
      <input type="password" name="password_confirmation" class="form-control" required style="width:100%;padding:10px;border:1px solid #ddd;border-radius:6px;">
    </div>

    <button class="btn" style="background:#1d4ed8;color:#fff;padding:10px 16px;border:0;border-radius:6px;">
      Update Password
    </button>
  </form>
@endsection
