@php($title = 'Login')
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1" />
  <title>{{ config('app.name', 'Smart ERP') }} — {{ $title }}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@400;600;700;800&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <style>
    :root { --bg:#eef0f2; --card:#fff; --primary:#1e73be; --accent:#e74c3c; --text:#3a3f45; --muted:#8c98a4; --border:#dfe3e8; --btn:#2c7dbe; }
    *{box-sizing:border-box}
    html,body{height:100%;margin:0;font-family:'Open Sans',system-ui,-apple-system,Segoe UI,Roboto,Arial,sans-serif;color:var(--text);background:var(--bg);background-image:linear-gradient(rgba(0,0,0,.04) 1px,transparent 1px),linear-gradient(90deg, rgba(0,0,0,.04) 1px, transparent 1px);background-size:40px 40px,40px 40px}
    .container{min-height:100%;display:flex;flex-direction:column;align-items:center;justify-content:flex-start;padding-top:70px;padding-bottom:40px}
    .logo{margin-bottom:18px;text-align:center}
    .logo img{height:92px;width:auto;object-fit:contain}
    .card{width:520px;max-width:calc(100% - 32px);background:var(--card);border:1px solid var(--border);border-radius:6px;box-shadow:0 12px 30px rgba(7,23,46,.08);overflow:hidden}
    .card-header{padding:16px 22px;border-bottom:1px solid var(--border);display:flex;align-items:center;gap:10px;font-weight:700;color:#5b8a52}
    .card-header i{color:#5b8a52}
    .card-header span{color:#376fa1;font-weight:600}
    .card-body{padding:22px}
    .form-row{margin-bottom:12px}
    label{display:block;font-size:13px;color:var(--muted);margin-bottom:6px}
    .input{position:relative}
    .input input{width:100%;padding:9px 40px 9px 12px;border:1px solid var(--border);border-radius:3px;font-size:14px;outline:none;background:#fff}
    .input input:focus{border-color:#f39c12;box-shadow:0 0 0 2px rgba(243,156,18,.15)}
    .suffix-btn{position:absolute;right:7px;top:50%;transform:translateY(-50%);width:28px;height:28px;border:0;background:transparent;cursor:pointer;color:#6d7a87}
    .remember{display:flex;align-items:center;gap:8px;margin:8px 0 16px;font-size:13px}
    .actions{display:flex;align-items:center;justify-content:flex-end}
    .btn-primary{background:#2c73a6;color:#fff;border:1px solid #2c73a6;border-radius:3px;padding:9px 18px;font-weight:700;cursor:pointer;box-shadow:inset 0 1px 0 rgba(255,255,255,.15)}
    .btn-primary:active{transform:translateY(1px)}
    .dev{margin-top:10px;text-align:center;color:var(--muted);font-size:12px}
    .dev a{color:#376fa1;text-decoration:none;font-weight:600}
    .footer-bar{border-top:1px solid var(--border);background:#3c7fa1;color:#fff;padding:11px 22px;font-size:14px;display:flex;align-items:center;gap:10px}
    .footer-bar a{color:#fff;text-decoration:none}
    .errors{margin:6px 0 0;color:#e74c3c;font-size:12px}
    @media (max-width:420px){.card{border-radius:0;box-shadow:none}}
  </style>
</head>
<body>
  <div class="container">
    <div class="logo">
      {{-- Replace with your logo image. Example below looks like the screenshot. --}}
      <img src="{{ asset('images/smart-erp-logo.png') }}" alt="Smart ERP" onerror="this.outerHTML='<div style=\'font-weight:800;font-size:50px;line-height:1\'><span style=\'color:#1e73be\'>Smart</span> <span style=\'color:#e74c3c\'>ERP</span></div>'">
    </div>

    <div class="card" role="region" aria-labelledby="loginHeading">
      <div class="card-header" id="loginHeading">
        <i class="fa-solid fa-right-to-bracket"></i>
        <span>Login Information</span>
      </div>

      <form class="card-body" method="POST" action="{{ route('login') }}">
        @csrf

        @if (session('status'))
          <div class="errors">{{ session('status') }}</div>
        @endif

        <div class="form-row">
          <label for="email">Email</label>
          <div class="input">
            <input type="email" id="email" name="email" value="{{ old('email') }}" placeholder="Email" autocomplete="username" required>
            <button type="button" class="suffix-btn" aria-label="email help"><i class="fa-regular fa-circle-question"></i></button>
          </div>
          @error('email')<div class="errors">{{ $message }}</div>@enderror
        </div>

        <div class="form-row">
          <label for="password">Password</label>
          <div class="input">
            <input type="password" id="password" name="password" placeholder="Password" autocomplete="current-password" required>
            <button type="button" class="suffix-btn" aria-label="toggle password" onclick="togglePassword()"><i class="fa-regular fa-eye" id="eye"></i></button>
          </div>
          @error('password')<div class="errors">{{ $message }}</div>@enderror
        </div>

        <label class="remember">
          <input type="checkbox" name="remember"> Remember Me
        </label>

        <div class="actions">
          <button class="btn-primary" type="submit"><i class="fa-solid fa-magnifying-glass"></i> Login</button>
        </div>

        <div class="dev">
          &copy; Developed By <a href="#">Smart Software Ltd</a>
        </div>
      </form>

      <div class="footer-bar">
        <i class="fa-solid fa-arrow-left"></i>
        <a class="forgot" href="{{ Route::has('password.request') ? route('password.request') : '#' }}">I forgot my password</a>
      </div>
    </div>
  </div>

  <script>
    function togglePassword(){
      const input=document.getElementById('password');
      const eye=document.getElementById('eye');
      const isHidden=input.type==='password';
      input.type=isHidden?'text':'password';
      eye.classList.toggle('fa-eye');
      eye.classList.toggle('fa-eye-slash');
    }
  </script>
</body>
</html>
