﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Raw Product Adjustment List</span>
      </div>
      <a href="{{ route('adjustment.raw_product.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i><span>Add Raw Product Adjustment</span>
      </a>
    </div>

    <div class="sx-body">
      <div class="table-responsive">
        <table class="table sx-table sx-table-list">
          <colgroup>
            <col style="width:80px">
            <col>
            <col style="width:220px">
            <col style="width:220px">
            <col style="width:180px">
          </colgroup>

          <thead>
            <tr>
              <th>SL</th>
              <th>Warehouse</th>
              <th>Total Adjust Qty</th>
              <th>Total Adjust Type</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>

          <tbody>
            @php($adjustments = $adjustments ?? collect()) {{-- ✅ safety net --}}
            @forelse($adjustments as $adj)
              <tr>
                <td>{{ $loop->iteration + (method_exists($adjustments, 'firstItem') ? $adjustments->firstItem() - 1 : 0) }}</td>
                <td>{{ $adj->warehouse->name ?? '-' }}</td>

                <td>
                  <ul class="sx-dotlist">
                    <li>{{ number_format($adj->total_qty, 2) }}</li>
                  </ul>
                </td>

                <td>
                  <ul class="sx-dotlist">
                    <li>{{ strtoupper($adj->adjust_type) }}</li>
                  </ul>
                </td>

                <td class="text-center sx-actions">
                  {{-- View --}}
                  <a class="sx-btn sx-btn-view" href="{{ route('adjustment.raw_product.show', $adj->id) }}" title="View">
                    <i class="fas fa-eye"></i>
                  </a>

                  {{-- Print (optional) --}}
                  <a class="sx-btn sx-btn-print" href="{{ route('adjustment.raw_product.show', $adj->id) }}?print=1" target="_blank" title="Print">
                    <i class="fas fa-print"></i>
                  </a>

                  {{-- Edit --}}
                  <a class="sx-btn sx-btn-edit" href="{{ route('adjustment.raw_product.edit', $adj->id) }}" title="Edit">
                    <i class="fas fa-edit"></i>
                  </a>

                  {{-- Delete --}}
                  <form action="{{ route('adjustment.raw_product.destroy', $adj->id) }}" method="POST" class="d-inline"
                        onsubmit="return confirm('Delete this adjustment?');">
                    @csrf @method('DELETE')
                    <button type="submit" class="sx-btn sx-btn-del" title="Delete">
                      <i class="fas fa-trash-alt"></i>
                    </button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="5" class="text-center text-muted py-4">No data found!</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      @if(method_exists($adjustments, 'links'))
        <div class="mt-2">
          {{ $adjustments->links() }}
        </div>
      @endif
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); background:#fff; border-radius:3px;}
.sx-head{display:flex; align-items:center; justify-content:space-between; background:var(--sx-blue-100); border-bottom:1px solid var(--sx-gray-250); padding:10px 12px;}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title); font-weight:600; font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; background:var(--sx-blue-200); border:1px solid var(--sx-blue-300);
  color:#2f6fa8; text-decoration:none; border-radius:3px; padding:6px 10px; font-weight:600;}
.sx-body{padding:12px;}

.sx-table{width:100%; border:1px solid var(--sx-gray-250); table-layout:fixed; margin:0;}
.sx-table thead th{background:#d8e5ff; color:#223; font-weight:600; padding:8px 10px; border-bottom:1px solid var(--sx-gray-200);}
.sx-table tbody td{padding:10px; vertical-align:middle; border-top:1px solid var(--sx-gray-220);}

.sx-dotlist{padding-left:20px; margin:0;}
.sx-dotlist li{list-style:disc;}

.sx-actions .sx-btn{display:inline-flex; align-items:center; justify-content:center; width:30px; height:30px;
  border-radius:4px; margin:0 2px; border:0; text-decoration:none; color:#fff;}
.sx-btn-view {background:#3bb273;}   /* green */
.sx-btn-print{background:#3aa5f3;}   /* blue */
.sx-btn-edit {background:#f3a23a;}   /* orange */
.sx-btn-del  {background:#e2574c;}   /* red */
.sx-btn i{font-size:14px;}
.sx-btn[type="submit"]{cursor:pointer;}

.sx-table-list thead th{background:#d7e5ff;}
</style>
@endpush


