﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-cog sx-head-ico"></i>
        <span class="sx-head-title">Create Raw Product Adjustment</span>
      </div>
      <a href="{{ route('adjustment.raw_product.index') }}" class="sx-head-link">
        <i class="fas fa-list"></i><span>Raw Product Adjustment List</span>
      </a>
    </div>

    <div class="sx-body">
      <form action="{{ route('adjustment.raw_product.store') }}" method="POST" id="rawAdjForm" autocomplete="off">
        @csrf

        {{-- Top filter row --}}
        <div class="sx-grid sx-grid-2">
          <div class="sx-row">
            <div class="sx-labelcell">Warehouse</div>
            <div class="sx-inputcell">
              <select name="warehouse_id" class="sx-input" required>
                <option value="">-Select Warehouse-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}">{{ $w->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-row">
            <div class="sx-labelcell">Date</div>
            <div class="sx-inputcell">
              <div class="sx-dategrp">
                <input type="date" name="date" value="{{ date('Y-m-d') }}" class="sx-input sx-date" required>
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
              </div>
            </div>
          </div>
        </div>

        {{-- Table --}}
        <div class="table-responsive">
          <table class="table sx-table" id="adjustTable">
            <colgroup>
              <col class="col-sl">
              <col class="col-pro">
              <col class="col-avail">
              <col class="col-qty">
              <col class="col-price">
              <col class="col-sub">
              <col class="col-type">
              <col class="col-act">
            </colgroup>

            <thead>
              <tr>
                <th class="text-center">SL.</th>
                <th>Product</th>
                <th>Available Qty</th>
                <th>Qty</th>
                <th>Price</th>
                <th>Subtotal</th>
                <th>Adjust Type</th>
                <th class="text-center"></th>
              </tr>
            </thead>

            <tbody id="adjItems">
              <tr class="sx-trow">
                <td class="text-center">1</td>
                <td>
                  <div class="sx-progrp">
                    <select name="items[0][product_id]" class="sx-input sx-product" required>
                      <option value="">-select product-</option>
                      @foreach($products as $p)
                        <option
                          value="{{ $p->id }}"
                          data-available="{{ $p->available_qty ?? 0 }}"
                        >{{ $p->name ?? ('#'.$p->id) }}</option>
                      @endforeach
                    </select>
                    <button type="button" class="sx-info" title="Product info"><i class="fas fa-info"></i></button>
                  </div>
                </td>
                <td>
                  <input type="text" class="sx-input sx-read sx-available" value="0.00" readonly>
                </td>
                <td>
                  <input type="number" step="0.01" name="items[0][qty]" class="sx-input sx-qty" placeholder="Quantity">
                </td>
                <td>
                  <input type="number" step="0.01" name="items[0][price]" class="sx-input sx-price" placeholder="Price">
                </td>
                <td>
                  <input type="number" step="0.01" name="items[0][subtotal]" class="sx-input sx-read sx-subtotal" placeholder="Sub Total" readonly>
                </td>
                <td>
                  <select name="items[0][adjust_type]" class="sx-input">
                    <option value="out">Out</option>
                    <option value="in">In</option>
                  </select>
                </td>
                <td class="text-center">
                  <button type="button" class="sx-minus remove-row" title="Remove"><i class="fas fa-minus"></i></button>
                </td>
              </tr>
            </tbody>

            <tfoot>
              <tr>
                <td colspan="7"></td>
                <td class="text-center">
                  <button type="button" class="sx-plus" id="addRow" title="Add"><i class="fas fa-plus"></i></button>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>

        <div class="sx-savewrap">
          <button type="submit" class="sx-save"><i class="fas fa-save"></i> Save</button>
        </div>
      </form>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7; --sx-blue-500:#3a6ea5;
  --sx-gray-050:#eaeff4; --sx-gray-080:#eef2f6; --sx-gray-100:#f6f8fb; --sx-gray-120:#eff3f7;
  --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
body, .sx-wrap { font-family:"Helvetica Neue",Arial,sans-serif; font-size:14px; color:var(--sx-text); }

/* Card & header */
.sx-wrap{border:1px solid var(--sx-gray-250)!important;border-radius:3px;background:#fff;}
.sx-head{display:flex;align-items:center;justify-content:space-between;background:var(--sx-blue-100);border-bottom:1px solid var(--sx-gray-250);padding:10px 12px;}
.sx-head-left{display:flex;align-items:center;gap:8px;}
.sx-head-ico{color:#6aa3c6;font-size:16px;}
.sx-head-title{color:var(--sx-title);font-weight:600;font-size:16px;}
.sx-head-link{display:inline-flex;align-items:center;gap:8px;background:var(--sx-blue-200);border:1px solid var(--sx-blue-300);color:#2f6fa8;text-decoration:none;border-radius:3px;padding:6px 10px;font-weight:600;}
.sx-body{padding:16px;}

/* Top grid */
.sx-grid.sx-grid-2{display:grid;grid-template-columns:1fr 1fr;gap:12px 24px;margin-bottom:10px;}
.sx-row{display:grid;grid-template-columns:160px 1fr;align-items:center;}
.sx-labelcell{background:#f2f5f9;border:1px solid #e3e9ef;color:#5d6b7a;font-weight:600;border-radius:3px;padding:8px 12px;}
.sx-input{width:100%;height:36px;line-height:36px;padding:4px 10px;border:1px solid var(--sx-gray-300);border-radius:3px;background:#fff;}
.sx-input::placeholder{color:#b9c3cf;}
.sx-input:focus{outline:0;border-color:#bcc7d6;}
.sx-dategrp{display:flex;}
.sx-date{border-right:0!important;}
.sx-date::-webkit-calendar-picker-indicator{display:none;}
.sx-datebtn{display:inline-flex;align-items:center;justify-content:center;width:36px;height:36px;background:#e6ebf1;border:1px solid var(--sx-gray-300);border-left:0;color:#6d7e90;border-radius:0 3px 3px 0;}

/* Table */
.sx-table{width:100%;border:1px solid var(--sx-gray-250);margin:0;table-layout:fixed;}
.sx-table thead th{background:var(--sx-gray-100);color:var(--sx-text);font-weight:600;padding:8px 10px;border-bottom:1px solid var(--sx-gray-200);border-right:1px solid var(--sx-gray-220);white-space:nowrap;}
.sx-table tbody td{padding:6px 8px;vertical-align:middle;border-right:1px solid var(--sx-gray-220);}
.sx-table tfoot td{background:var(--sx-gray-120);border-top:1px solid var(--sx-gray-200);padding:6px 8px;}
.table>:not(caption)>*>*{box-shadow:none!important;}

.col-sl{width:60px}
.col-pro{width:auto}
.col-avail{width:170px}
.col-qty{width:140px}
.col-price{width:160px}
.col-sub{width:180px}
.col-type{width:140px}
.col-act{width:70px}

/* Product group */
.sx-progrp{display:flex;width:100%;}
.sx-progrp .sx-input{border-right:0;border-radius:3px 0 0 3px;flex:1 1 auto;min-width:0;}
.sx-info{width:36px;height:36px;display:inline-flex;align-items:center;justify-content:center;border:1px solid #b7d1f6;border-left:0;background:#e0ecff;color:#2e78c7;border-radius:0 3px 3px 0;}

/* Read-only */
.sx-read{background:var(--sx-gray-050)!important;}

/* Buttons */
.sx-minus{width:38px;height:28px;background:#d9534f;color:#fff;border:1px solid #c9443f;border-radius:3px;padding:0;}
.sx-plus{width:38px;height:28px;background:#f0ad4e;color:#fff;border:1px solid #e39a30;border-radius:3px;padding:0;}
.sx-savewrap{display:flex;justify-content:flex-end;margin-top:10px;}
.sx-save{display:inline-flex;align-items:center;gap:8px;background:#5fb36b;color:#fff;border:1px solid #479b52;padding:7px 16px;border-radius:3px;font-weight:700;}

/* Responsive */
@media (max-width: 991.98px){ .sx-grid.sx-grid-2{grid-template-columns:1fr;} }
</style>
@endpush

@push('scripts')
<script>
(function($){
  let rowCount = 1;

  function renumber(){
    $('#adjItems .sx-trow').each(function(i){
      $(this).find('td:first').text(i+1);
    });
  }

  function setAvailable($row){
    const $opt = $row.find('.sx-product option:selected');
    const avail = parseFloat($opt.data('available')) || 0;
    $row.find('.sx-available').val(avail.toFixed(2));
  }

  function calcRow($row){
    const q = parseFloat($row.find('.sx-qty').val())   || 0;
    const p = parseFloat($row.find('.sx-price').val()) || 0;
    $row.find('.sx-subtotal').val((q*p).toFixed(2));
  }

  // Add Row
  $('#addRow').on('click', function(){
    const i = rowCount;
    const tpl = `
      <tr class="sx-trow">
        <td class="text-center">${i+1}</td>
        <td>
          <div class="sx-progrp">
            <select name="items[${i}][product_id]" class="sx-input sx-product" required>
              <option value="">-select product-</option>
              @foreach($products as $p)
                <option value="{{ $p->id }}" data-available="{{ $p->available_qty ?? 0 }}">{{ $p->name ?? ('#'.$p->id) }}</option>
              @endforeach
            </select>
            <button type="button" class="sx-info" title="Product info"><i class="fas fa-info"></i></button>
          </div>
        </td>
        <td><input type="text" class="sx-input sx-read sx-available" value="0.00" readonly></td>
        <td><input type="number" step="0.01" name="items[${i}][qty]"    class="sx-input sx-qty"    placeholder="Quantity"></td>
        <td><input type="number" step="0.01" name="items[${i}][price]"  class="sx-input sx-price"  placeholder="Price"></td>
        <td><input type="number" step="0.01" name="items[${i}][subtotal]" class="sx-input sx-read sx-subtotal" placeholder="Sub Total" readonly></td>
        <td>
          <select name="items[${i}][adjust_type]" class="sx-input">
            <option value="out">Out</option>
            <option value="in">In</option>
          </select>
        </td>
        <td class="text-center"><button type="button" class="sx-minus remove-row" title="Remove"><i class="fas fa-minus"></i></button></td>
      </tr>`;
    $('#adjItems').append(tpl);
    rowCount++; renumber();
  });

  // Remove Row
  $(document).on('click', '.remove-row', function(){
    if ($('#adjItems .sx-trow').length <= 1) { alert('At least one item is required'); return; }
    $(this).closest('tr').remove(); renumber();
  });

  // On product change -> set available
  $(document).on('change', '.sx-product', function(){
    setAvailable($(this).closest('tr'));
  });

  // Qty/Price input -> subtotal
  $(document).on('input', '.sx-qty, .sx-price', function(){
    calcRow($(this).closest('tr'));
  });

  // Init first row
  setAvailable($('#adjItems .sx-trow').first());

})(jQuery);
</script>
@endpush
