﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Raw Bag Opening List</span>
      </div>
      <a href="{{ route('adjustment.raw_bag_opening.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i> <span>Add Raw Bag Opening</span>
      </a>
    </div>

    <div class="sx-body">
      {{-- Filters --}}
      <form method="GET" action="{{ route('adjustment.raw_bag_opening.index') }}" class="sx-filter">
        <div class="sx-filter-grid">
          <div class="sx-fcell">
            <div class="sx-flabel">Company</div>
            <div>
              <select name="company_id" class="sx-input">
                <option value="">-Company Name-</option>
                @foreach($companies as $c)
                  <option value="{{ $c->id }}" {{ request('company_id')==$c->id?'selected':'' }}>
                    {{ $c->name }}
                  </option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-fcell">
            <div class="sx-flabel">Warehouse</div>
            <div>
              <select name="warehouse_id" class="sx-input">
                <option value="">-Warehouse Name-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}" {{ request('warehouse_id')==$w->id?'selected':'' }}>
                    {{ $w->name }}
                  </option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="sx-fcell sx-fcell-action">
            <div class="sx-flabel">Action</div>
            <div class="sx-actionbar">
              <button type="submit" class="sx-btn sx-btn-search">
                <i class="fas fa-search"></i> Search
              </button>
              <a href="{{ route('adjustment.raw_bag_opening.index') }}" class="sx-btn sx-btn-refresh" title="Reset">
                <i class="fas fa-sync-alt"></i>
              </a>
            </div>
          </div>
        </div>
      </form>

      {{-- Table --}}
      <div class="table-responsive">
        <table class="table sx-table sx-table-list">
          <colgroup>
            <col style="width:70px">
            <col>
            <col>
            <col style="width:160px">
            <col>
            <col style="width:170px">
          </colgroup>

        <thead>
          <tr>
            <th>SL</th>
            <th>Company</th>
            <th>Warehouse Name</th>
            <th>Quantity</th>
            <th>Remarks</th>
            <th>Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($openings as $idx => $row)
            <tr>
              <td>{{ $openings->firstItem() + $idx }}</td>
              <td>{{ $row->company->name ?? '-' }}</td>
              <td>{{ $row->warehouse->name ?? '-' }}</td>
              <td>{{ number_format($row->opening_qty, 0) }}</td>
              <td>{{ $row->note }}</td>
              <td class="sx-actions">
                <a class="sx-btn sx-btn-view" href="{{ route('adjustment.raw_bag_opening.show', $row->id) }}" title="View">
                  <i class="fas fa-eye"></i>
                </a>
                <a class="sx-btn sx-btn-edit" href="{{ route('adjustment.raw_bag_opening.edit', $row->id) }}" title="Edit">
                  <i class="fas fa-edit"></i>
                </a>
                <form action="{{ route('adjustment.raw_bag_opening.destroy', $row->id) }}"
                      method="POST" class="d-inline"
                      onsubmit="return confirm('Delete this opening entry?');">
                  @csrf @method('DELETE')
                  <button type="submit" class="sx-btn sx-btn-del" title="Delete">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="6" class="text-center text-muted py-4">No data available in table</td>
            </tr>
          @endforelse
        </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      @if(method_exists($openings,'links'))
        <div class="mt-2">
          {{ $openings->withQueryString()->links() }}
        </div>
      @endif
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); background:#fff; border-radius:3px;}
.sx-head{display:flex; align-items:center; justify-content:space-between; background:var(--sx-blue-100);
  border-bottom:1px solid var(--sx-gray-250); padding:10px 12px;}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title); font-weight:600; font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; background:var(--sx-blue-200); border:1px solid var(--sx-blue-300);
  color:#2f6fa8; text-decoration:none; border-radius:3px; padding:6px 10px; font-weight:600;}
.sx-body{padding:12px;}

.sx-filter-grid{display:grid; grid-template-columns:1fr 1fr 220px; gap:10px;}
.sx-flabel{background:#e9eef6; border:1px solid #dfe6ef; color:#51616f; font-weight:600; padding:8px 10px; border-radius:3px 3px 0 0;}
.sx-fcell > div:last-child{border:1px solid var(--sx-gray-300); border-top:0; padding:8px; border-radius:0 0 3px 3px;}
.sx-input{width:100%; height:36px; border:1px solid var(--sx-gray-300); border-radius:3px; padding:4px 10px;}
.sx-fcell-action .sx-flabel{visibility:hidden;} /* empty header like screenshot */
.sx-actionbar{display:flex; gap:8px; align-items:center;}
.sx-btn{display:inline-flex; align-items:center; gap:8px; padding:7px 14px; border-radius:3px; border:1px solid transparent; font-weight:600;}
.sx-btn-search{background:#3a86d1; color:#fff; border-color:#2f78c0;}
.sx-btn-refresh{background:#e9eef7; color:#3a86d1; border-color:#cfd8e3; text-decoration:none;}

.sx-table{width:100%; border:1px solid var(--sx-gray-250); table-layout:fixed; margin-top:12px;}
.sx-table thead th{background:#e6f0ff; color:#223; font-weight:600; padding:8px 10px; border-bottom:1px solid var(--sx-gray-200);}
.sx-table tbody td{padding:10px; vertical-align:middle; border-top:1px solid var(--sx-gray-220);}

.sx-actions .sx-btn{width:34px; height:30px; padding:0; justify-content:center; color:#fff;}
.sx-btn-view {background:#3bb273;}
.sx-btn-edit {background:#f3a23a;}
.sx-btn-del  {background:#e2574c;}
</style>
@endpush
