﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-cubes sx-head-ico"></i>
        <span class="sx-head-title">Raw Bag Opening</span>
      </div>
      <a href="{{ route('adjustment.raw_bag_opening.index') }}" class="sx-head-link">
        <i class="fas fa-list"></i> <span>Raw Bag Opening List</span>
      </a>
    </div>

    <div class="sx-body">
      <form action="{{ route('adjustment.raw_bag_opening.store') }}" method="POST" id="rboForm" autocomplete="off">
        @csrf

        <div class="sx-form">
          {{-- Company --}}
          <div class="sx-row">
            <div class="sx-label">Company Name*</div>
            <div class="sx-field">
              <select name="company_id" class="sx-input" required>
                <option value="">-Company Name-</option>
                @foreach($companies as $c)
                  <option value="{{ $c->id }}" {{ old('company_id')==$c->id?'selected':'' }}>{{ $c->name }}</option>
                @endforeach
              </select>
              @error('company_id') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
          </div>

          {{-- Warehouse --}}
          <div class="sx-row">
            <div class="sx-label">Warehouse Name*</div>
            <div class="sx-field">
              <select name="warehouse_id" class="sx-input" required>
                <option value="">-Select Warehouse-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}" {{ old('warehouse_id')==$w->id?'selected':'' }}>{{ $w->name }}</option>
                @endforeach
              </select>
              @error('warehouse_id') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
          </div>

          {{-- Bag Stock (readonly) --}}
          <div class="sx-row">
            <div class="sx-label">Bag Stock</div>
            <div class="sx-field">
              <input type="text"
                     class="sx-input sx-readonly"
                     value="{{ number_format($bagStock ?? 0, 0) }}"
                     placeholder="Stock Bag Quantity"
                     readonly>
            </div>
          </div>

          {{-- Opening Quantity --}}
          <div class="sx-row">
            <div class="sx-label">Opening Quantity*</div>
            <div class="sx-field">
              <input type="number" name="opening_qty" class="sx-input" step="1" min="0.01"
                     value="{{ old('opening_qty') }}" placeholder="Opening Bag Quantity" required>
              @error('opening_qty') <small class="text-danger">{{ $message }}</small> @enderror
            </div>
          </div>

          {{-- Remarks --}}
          <div class="sx-row">
            <div class="sx-label">Remarks</div>
            <div class="sx-field">
              <input type="text" name="note" class="sx-input" placeholder="Enter the Remarks"
                     value="{{ old('note') }}">
            </div>
          </div>

          {{-- Actions --}}
          <div class="sx-actions">
            <button type="submit" class="sx-btn sx-btn-save">
              <i class="fas fa-save"></i> Save
            </button>
            <button type="reset" class="sx-btn sx-btn-reset">
              <i class="fas fa-sync-alt"></i> Reset
            </button>
          </div>
        </div>
      </form>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); border-radius:3px; background:#fff;}
.sx-head{display:flex; align-items:center; justify-content:space-between; padding:10px 12px;
  background:var(--sx-blue-100); border-bottom:1px solid var(--sx-gray-250);}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{font-weight:600; color:var(--sx-title); font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; padding:6px 10px;
  background:var(--sx-blue-200); border:1px solid var(--sx-blue-300); color:#2f6fa8;
  text-decoration:none; border-radius:3px; font-weight:600;}
.sx-body{padding:14px;}

.sx-form{max-width:1120px; margin:0 auto;}
.sx-row{display:grid; grid-template-columns:220px 1fr; gap:12px; margin-bottom:10px;}
.sx-label{background:#f2f5f9; border:1px solid #e3e9ef; color:#5d6b7a; font-weight:600;
  border-radius:3px; padding:8px 12px;}
.sx-field{}
.sx-input{width:100%; height:38px; padding:6px 10px; border:1px solid var(--sx-gray-300);
  border-radius:3px; background:#fff;}
.sx-input::placeholder{color:#b8c2cf;}
.sx-readonly{background:#e8edf3!important; color:#7d8794;}
.sx-actions{display:flex; gap:10px; justify-content:flex-end; margin-top:14px;}
.sx-btn{display:inline-flex; align-items:center; gap:8px; padding:8px 16px;
  border-radius:3px; border:1px solid transparent; font-weight:600;}
.sx-btn-save{background:#5fb36b; color:#fff; border-color:#479b52;}
.sx-btn-reset{background:#e9eef7; color:#3a86d1; border-color:#cfd8e3;}
</style>
@endpush
