﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Raw Bag Adjustment List</span>
      </div>
      <a href="{{ route('adjustment.raw_bag.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i><span>Add Raw Bag Adjustment</span>
      </a>
    </div>

    <div class="sx-body">
      {{-- Filters --}}
      <form method="GET" class="sx-filter">
        <div class="sx-filter-grid">
          <div class="sx-filter-cell">
            <div class="sx-filter-label">Company</div>
            <select name="company_id" class="sx-input">
              <option value="">-Company Name-</option>
              @foreach($companies as $c)
                <option value="{{ $c->id }}" {{ request('company_id')==$c->id?'selected':'' }}>
                  {{ $c->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="sx-filter-cell">
            <div class="sx-filter-label">Warehouse</div>
            <select name="warehouse_id" class="sx-input">
              <option value="">-Warehouse Name-</option>
              @foreach($warehouses as $w)
                <option value="{{ $w->id }}" {{ request('warehouse_id')==$w->id?'selected':'' }}>
                  {{ $w->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="sx-filter-cell">
            <div class="sx-filter-label">Filter by Date</div>
            <div class="sx-date-range">
              <div class="sx-dategrp">
                <span class="sx-dateico"><i class="far fa-calendar"></i></span>
                <input type="date" name="from" value="{{ request('from') }}" class="sx-input sx-date">
              </div>
              <div class="sx-date-sep"><i class="fas fa-exchange-alt"></i></div>
              <div class="sx-dategrp">
                <input type="date" name="to" value="{{ request('to') }}" class="sx-input sx-date">
                <span class="sx-dateico"><i class="far fa-calendar"></i></span>
              </div>
            </div>
          </div>

          <div class="sx-filter-actions">
            <button type="submit" class="sx-btn sx-btn-search"><i class="fas fa-search"></i> Search</button>
            <a href="{{ route('adjustment.raw_bag.index') }}" class="sx-btn sx-btn-reset"><i class="fas fa-sync-alt"></i></a>
          </div>
        </div>
      </form>

      {{-- Table --}}
      <div class="table-responsive">
        <table class="table sx-table sx-table-list">
          <colgroup>
            <col style="width:70px">
            <col style="width:140px">
            <col>
            <col>
            <col style="width:160px">
            <col style="width:160px">
            <col>
            <col style="width:150px">
          </colgroup>

          <thead>
            <tr>
              <th>SL</th>
              <th>Date</th>
              <th>Company</th>
              <th>Warehouse Name</th>
              <th>Adjust Quantity</th>
              <th>Adjustment type</th>
              <th>Remarks</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>

          <tbody>
            @forelse($adjustments as $idx => $adj)
              <tr>
                <td>{{ $loop->iteration + ($adjustments->currentPage()-1)*$adjustments->perPage() }}</td>
                <td>{{ \Carbon\Carbon::parse($adj->date)->format('Y-m-d') }}</td>
                <td>{{ $adj->company->name ?? '-' }}</td>
                <td>{{ $adj->warehouse->name ?? '-' }}</td>
                <td>{{ number_format($adj->total_qty, 0) }}</td>
                <td>{{ strtoupper($adj->adjust_type ?? '-') }}</td>
                <td>{{ $adj->note }}</td>
                <td class="text-center sx-actions">
                  <a class="sx-btn sx-btn-view" href="{{ route('adjustment.raw_bag.show', $adj->id) }}" title="View"><i class="fas fa-eye"></i></a>
                  <a class="sx-btn sx-btn-edit" href="{{ route('adjustment.raw_bag.edit', $adj->id) }}" title="Edit"><i class="fas fa-edit"></i></a>
                  <form action="{{ route('adjustment.raw_bag.destroy', $adj->id) }}" method="POST" class="d-inline"
                        onsubmit="return confirm('Delete this adjustment?');">
                    @csrf @method('DELETE')
                    <button type="submit" class="sx-btn sx-btn-del" title="Delete"><i class="fas fa-trash-alt"></i></button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="8" class="text-center text-muted py-4">No data available in table</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      @if(method_exists($adjustments, 'links'))
        <div class="mt-2">
          {{ $adjustments->appends(request()->query())->links() }}
        </div>
      @endif
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec; --sx-gray-300:#cfd8e3;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); background:#fff; border-radius:3px;}
.sx-head{display:flex; align-items:center; justify-content:space-between; background:var(--sx-blue-100);
  border-bottom:1px solid var(--sx-gray-250); padding:10px 12px;}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title); font-weight:600; font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; background:var(--sx-blue-200); border:1px solid var(--sx-blue-300);
  color:#2f6fa8; text-decoration:none; border-radius:3px; padding:6px 10px; font-weight:600;}

.sx-body{padding:12px;}

.sx-filter{margin-bottom:8px;}
.sx-filter-grid{display:grid; grid-template-columns: 1fr 1fr 2fr 200px; gap:10px; align-items:end;}
.sx-filter-label{font-weight:600; color:#3f4d67; margin-bottom:6px;}
.sx-input{width:100%; height:36px; padding:6px 10px; border:1px solid var(--sx-gray-300); border-radius:3px; background:#fff;}
.sx-date-range{display:grid; grid-template-columns: 1fr 40px 1fr; gap:8px; align-items:center;}
.sx-dategrp{position:relative; display:flex; align-items:center;}
.sx-date{height:36px;}
.sx-dateico{display:inline-flex; align-items:center; justify-content:center; width:36px; height:36px; background:#e6ebf1;
  border:1px solid var(--sx-gray-300); border-right:0; color:#6d7e90; border-radius:3px 0 0 3px;}
.sx-dategrp .sx-date{border-left:0; border-radius:0 3px 3px 0;}
.sx-date-sep{display:flex; align-items:center; justify-content:center; color:#6c7f95;}

.sx-filter-actions{display:flex; gap:8px; justify-content:flex-end;}
.sx-btn{display:inline-flex; align-items:center; gap:8px; padding:7px 12px; border-radius:3px; border:1px solid transparent; font-weight:600;}
.sx-btn-search{background:#3a86d1; color:#fff; border-color:#2e74b8;}
.sx-btn-reset{background:#edf2f8; color:#3a86d1; border-color:#cfd8e3;}

.sx-table{width:100%; border:1px solid var(--sx-gray-250); table-layout:fixed; margin:0;}
.sx-table thead th{background:#d8e5ff; color:#223; font-weight:600; padding:8px 10px; border-bottom:1px solid var(--sx-gray-200);}
.sx-table tbody td{padding:9px 10px; vertical-align:middle; border-top:1px solid var(--sx-gray-220);}

.sx-actions .sx-btn{width:32px; height:32px; justify-content:center; padding:0; color:#fff; border:0;}
.sx-btn-view{background:#3bb273;}
.sx-btn-edit{background:#f3a23a;}
.sx-btn-del{background:#e2574c;}
</style>
@endpush