﻿@extends('layouts.app')

@section('title','GS Stock Adjustment List')

@section('content')
<div class="container-fluid">

  {{-- Title row --}}
  <div class="gsx-titlebar">
    <div class="gsx-title">
      <i class="fas fa-list"></i>
      <span>GS Stock Adjustment List</span>
    </div>
    <a href="{{ route('adjustment.new_gs.create') }}" class="gsx-add-btn">
      <i class="fas fa-plus"></i> Add GS Stock Adjustment
    </a>
  </div>

  {{-- FILTER PANEL (table-like with blue column headers) --}}
  <form method="GET" action="{{ route('adjustment.new_gs.index') }}" class="gsx-filter">
    <div class="gsx-filter-grid">

      <div class="gsx-cell">
        <div class="gsx-th">Company</div>
        <div class="gsx-td">
          <select name="company_id" class="gsx-inp">
            <option value="">-Company Name-</option>
            @foreach(($companies ?? []) as $c)
              <option value="{{ $c->id }}" @selected(request('company_id')==$c->id)>{{ $c->name }}</option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="gsx-cell">
        <div class="gsx-th">Warehouse</div>
        <div class="gsx-td">
          <select name="warehouse_id" class="gsx-inp">
            <option value="">-Warehouse Name-</option>
            @foreach(($warehouses ?? []) as $w)
              <option value="{{ $w->id }}" @selected(request('warehouse_id')==$w->id)>{{ $w->name }}</option>
            @endforeach
          </select>
        </div>
      </div>

      <div class="gsx-cell">
        <div class="gsx-th">Filter by Date</div>
        <div class="gsx-td gsx-date-row">
          <div class="gsx-date">
            <span class="gsx-icon"><i class="far fa-calendar"></i></span>
            <input type="date" name="date_from" class="gsx-inp" value="{{ request('date_from') }}" placeholder="From Date">
          </div>
          <div class="gsx-date">
            <span class="gsx-icon"><i class="fas fa-exchange-alt"></i></span>
            <input type="date" name="date_to" class="gsx-inp" value="{{ request('date_to') }}" placeholder="To Date">
          </div>
        </div>
      </div>

      <div class="gsx-cell">
        <div class="gsx-th">Action</div>
        <div class="gsx-td gsx-actions">
          <button class="gsx-search-btn" type="submit"><i class="fas fa-search"></i> Search</button>
          <a href="{{ route('adjustment.new_gs.index') }}" class="gsx-reset-btn" title="Reset">
            <i class="fas fa-sync"></i>
          </a>
        </div>
      </div>

    </div>
  </form>

  {{-- LIST TABLE --}}
  <div class="table-responsive">
    <table class="table gsx-table">
      <thead>
        <tr>
          <th style="width:80px;">SL</th>
          <th style="width:150px;">Date</th>
          <th>Company</th>
          <th>Warehouse</th>
          <th>Remarks</th>
          <th style="width:150px;" class="text-end">Total In Qty</th>
          <th style="width:150px;" class="text-end">Total Out Qty</th>
          <th style="width:120px;">Action</th>
        </tr>
      </thead>
      <tbody>
      @forelse($adjustments as $i => $row)
        @php
          $inQty  = $row->diff_qty > 0 ? number_format($row->diff_qty, 3) : '0.000';
          $outQty = $row->diff_qty < 0 ? number_format(abs($row->diff_qty), 3) : '0.000';
        @endphp
        <tr>
          <td class="text-center">{{ ($adjustments->firstItem() ?? 1) + $i }}</td>
          <td>{{ optional($row->adjusted_at)->format('Y-m-d') }}</td>
          <td>{{ $row->company->name ?? '-' }}</td>
          <td>{{ $row->warehouse->name ?? '-' }}</td>
          <td>{{ $row->note ?? $row->reason ?? '' }}</td>
          <td class="text-end">{{ $inQty }}</td>
          <td class="text-end">{{ $outQty }}</td>
          <td>
            <div class="d-flex gap-2">
              <a href="{{ route('adjustment.new_gs.edit', $row->id) }}" class="btn btn-sm btn-outline-primary">
                <i class="far fa-edit"></i>
              </a>
              <form action="{{ route('adjustment.new_gs.destroy', $row->id) }}" method="POST" onsubmit="return confirm('Delete this adjustment?')">
                @csrf @method('DELETE')
                <button class="btn btn-sm btn-outline-danger">
                  <i class="far fa-trash-alt"></i>
                </button>
              </form>
            </div>
          </td>
        </tr>
      @empty
        <tr>
          <td colspan="8" class="text-center gsx-empty">No data found!</td>
        </tr>
      @endforelse
      </tbody>
    </table>
  </div>

  {{-- Pagination --}}
  <div class="mt-2">
    {{ $adjustments->withQueryString()->links() }}
  </div>

</div>
@endsection

@push('styles')
<style>
/* --- Palette & Base --- */
:root{
  --gsx-blue:#d6e4ff;        /* header blue (close to screenshot) */
  --gsx-blue2:#cfe0ff;
  --gsx-border:#dfe5ec;
  --gsx-text:#30465a;
  --gsx-muted:#6b7b88;
  --gsx-danger:#d9534f;
  --gsx-primary:#2f7dd0;
  --gsx-primary-dark:#2468ac;
}
.gsx-titlebar{
  display:flex; justify-content:space-between; align-items:center;
  margin:2px 0 10px 0;
}
.gsx-title{
  display:flex; align-items:center; gap:8px;
  color:#2b3d57; font-weight:600; font-size:20px;
}
.gsx-title .fa-list{color:#2b9bd8;}
.gsx-add-btn{
  display:inline-flex; align-items:center; gap:6px;
  background:#2f7dd0; color:#fff; border:1px solid #2468ac;
  padding:6px 12px; border-radius:3px; text-decoration:none; font-weight:600; font-size:13px;
}
.gsx-add-btn:hover{ background:#2468ac; color:#fff; }

/* --- Filter Table --- */
.gsx-filter{
  border:1px solid var(--gsx-border);
  background:#fff; border-radius:3px; margin-bottom:10px;
}
.gsx-filter-grid{
  display:grid;
  grid-template-columns: 1.2fr 1.2fr 1.8fr 0.8fr;
  gap:0; border-collapse:separate;
}
.gsx-cell{ border-right:1px solid var(--gsx-border); }
.gsx-cell:last-child{ border-right:0; }
.gsx-th{
  background:var(--gsx-blue);
  padding:8px 10px; font-weight:700; color:var(--gsx-text);
  border-bottom:1px solid var(--gsx-border);
}
.gsx-td{ padding:8px 10px; background:#fff; }
.gsx-inp{
  width:100%; height:34px; border:1px solid #c9d5e2; border-radius:2px; padding:6px 8px; background:#fff;
  font-size:13px;
}
.gsx-date-row{ display:grid; grid-template-columns:1fr 1fr; gap:8px; }
.gsx-date{ display:flex; align-items:center; }
.gsx-icon{
  width:32px; height:34px; display:inline-flex; align-items:center; justify-content:center;
  border:1px solid #c9d5e2; border-right:0; background:#f4f7fb; color:#6b7b88; border-radius:2px 0 0 2px;
}
.gsx-date .gsx-inp{ border-left:0; border-radius:0 2px 2px 0; }

.gsx-actions{ display:flex; gap:8px; justify-content:flex-start; align-items:center; }
.gsx-search-btn{
  background:#2f7dd0; color:#fff; border:1px solid #2468ac; height:34px; padding:0 12px;
  border-radius:3px; font-weight:700; font-size:13px;
}
.gsx-search-btn:hover{ background:#2468ac; }
.gsx-reset-btn{
  display:inline-flex; align-items:center; justify-content:center; width:34px; height:34px;
  border:1px solid #bfcad8; color:#546679; background:#f6f8fb; border-radius:3px; text-decoration:none;
}
.gsx-reset-btn:hover{ background:#e9eef5; }

/* --- Data Table --- */
.gsx-table{
  width:100%; margin:0; border:1px solid var(--gsx-border); table-layout:fixed; border-collapse:collapse;
}
.gsx-table thead th{
  background:var(--gsx-blue); color:var(--gsx-text);
  font-weight:700; padding:8px 10px; border-bottom:1px solid var(--gsx-border); white-space:nowrap;
}
.gsx-table tbody td{
  padding:7px 10px; border-top:1px solid var(--gsx-border); vertical-align:middle; font-size:13px;
}
.gsx-empty{ color:var(--gsx-danger); font-weight:700; }
.text-end{text-align:right;}
.text-center{text-align:center;}
</style>
@endpush

