﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="gs-card">
    {{-- Header --}}
    <div class="gs-head">
      <div class="gs-head-left">
        <i class="fas fa-cog"></i>
        <span>Gs Stock Adjustment</span>
      </div>
      <a href="{{ route('adjustment.new_gs.index') }}" class="gs-link">
        <i class="fas fa-list"></i> Stock Adjustment List
      </a>
    </div>

    <div class="gs-body">
      <form action="{{ route('adjustment.new_gs.store') }}" method="POST" id="gsForm" autocomplete="off">
        @csrf

        {{-- Top row: company / warehouse --}}
        <div class="gs-grid-2">
          <div class="gs-row">
            <div class="gs-label">Company</div>
            <div>
              <select name="company_id" class="gs-inp" required>
                <option value="">-Select Company-</option>
                @foreach($companies as $c)
                  <option value="{{ $c->id }}">{{ $c->name }}</option>
                @endforeach
              </select>
            </div>
          </div>

          <div class="gs-row">
            <div class="gs-label">Warehouse</div>
            <div>
              <select name="warehouse_id" class="gs-inp" required>
                <option value="">-Warehouse Name-</option>
                @foreach($warehouses as $w)
                  <option value="{{ $w->id }}">{{ $w->name }}</option>
                @endforeach
              </select>
            </div>
          </div>
        </div>

        {{-- Remarks --}}
        <div class="gs-row gs-mt-8">
          <div class="gs-label">Remarks</div>
          <div>
            <input type="text" name="note" class="gs-inp" placeholder="remarks">
          </div>
        </div>

        <div class="gs-title">Stock Adjustment</div>

        {{-- Table --}}
        <div class="table-responsive">
          <table class="table gs-table" id="adjTable">
            <colgroup>
              <col style="width:70px">
              <col>
              <col style="width:160px">
              <col style="width:180px">
              <col style="width:180px">
              <col style="width:180px">
              <col style="width:140px">
              <col style="width:90px">
            </colgroup>

            <thead>
              <tr>
                <th>SL</th>
                <th>Item</th>
                <th>Unit</th>
                <th>Stock</th>
                <th>Quantity</th>
                <th>Rate</th>
                <th>Stock Type</th>
                <th>Action</th>
              </tr>
            </thead>

            <tbody id="gsRows">
              <tr class="gs-tr">
                <td class="text-center">1</td>
                <td>
                  <select name="items[0][item_id]" class="gs-inp gs-item" required>
                    <option value="">select</option>
                    @foreach($items as $it)
                      <option value="{{ $it->id }}"
                              data-unit="{{ $it->unit_name ?? '' }}"
                              data-stock="{{ number_format($it->stock ?? 0, 2, '.', '') }}">
                        {{ $it->name }}
                      </option>
                    @endforeach
                  </select>
                </td>
                <td>
                  <input type="text" class="gs-inp gs-read gs-unit" placeholder="Unit" readonly>
                </td>
                <td>
                  <input type="text" class="gs-inp gs-read gs-stock" placeholder="Stock" readonly>
                </td>
                <td>
                  <input type="number" step="0.01" min="0" name="items[0][qty]" class="gs-inp gs-qty" placeholder="Quantity">
                </td>
                <td>
                  <input type="number" step="0.01" min="0" name="items[0][rate]" class="gs-inp gs-rate" placeholder="Rate">
                </td>
                <td>
                  <select name="items[0][adjust_type]" class="gs-inp">
                    <option value="OUT">Out</option>
                    <option value="IN">In</option>
                  </select>
                </td>
                <td class="text-center">
                  <button type="button" class="btn btn-sm btn-danger gs-remove"><i class="fas fa-times"></i></button>
                </td>
              </tr>
            </tbody>

            <tfoot>
              <tr>
                <td colspan="8" class="text-end">
                  <button type="button" id="addRow" class="btn btn-sm btn-dark gs-add">
                    + Add New
                  </button>
                </td>
              </tr>
            </tfoot>
          </table>
        </div>

        <div class="gs-savewrap">
          <button type="submit" class="btn btn-success px-4">
            <i class="fas fa-save"></i> Save
          </button>
        </div>
      </form>
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --c-head:#f3f7fb; --c-border:#dfe5ec; --c-th:#e7f0ff; --c-text:#5b6b7a;
}
.gs-card{border:1px solid var(--c-border); background:#fff; border-radius:3px;}
.gs-head{display:flex; justify-content:space-between; align-items:center; background:var(--c-head); border-bottom:1px solid var(--c-border); padding:10px 12px;}
.gs-head-left{display:flex; align-items:center; gap:8px; color:#2b3d57; font-weight:600;}
.gs-link{display:inline-flex; align-items:center; gap:8px; background:#eaf2fb; border:1px solid #cfe0f7; color:#2f6fa8; padding:6px 10px; border-radius:3px; text-decoration:none; font-weight:600;}
.gs-body{padding:14px;}
.gs-grid-2{display:grid; grid-template-columns:1fr 1fr; gap:10px 24px;}
.gs-row{display:grid; grid-template-columns:140px 1fr; align-items:center; gap:8px;}
.gs-label{background:#f2f5f9; border:1px solid #e3e9ef; padding:8px 10px; border-radius:3px; font-weight:600; color:var(--c-text);}
.gs-inp{width:100%; height:36px; border:1px solid #cfd8e3; border-radius:3px; padding:6px 10px; background:#fff;}
.gs-inp:focus{outline:0; border-color:#b9c7df;}
.gs-read{background:#eef2f6;}
.gs-mt-8{margin-top:8px;}
.gs-title{font-size:22px; color:#3a6ea5; font-weight:600; margin:14px 0 10px;}
.gs-table{width:100%; border:1px solid var(--c-border); margin:0; table-layout:fixed;}
.gs-table thead th{background:var(--c-th); border-bottom:1px solid var(--c-border); padding:8px 10px; font-weight:600; white-space:nowrap;}
.gs-table tbody td{padding:6px 8px; vertical-align:middle; border-top:1px solid var(--c-border);}
.gs-add{background:#222; color:#fff; border-color:#111;}
.gs-savewrap{display:flex; justify-content:center; margin-top:14px;}
.text-center{text-align:center;}
.text-end{text-align:right;}
</style>
@endpush

@push('scripts')
<script>
(function($){
  let row = 1;

  function renumber(){
    $('#gsRows .gs-tr').each(function(i){
      $(this).find('td:first').text(i+1);
    });
  }

  // When item changes, populate unit and stock from option data-*
  $(document).on('change', '.gs-item', function(){
    const $tr   = $(this).closest('tr');
    const unit  = $(this).find(':selected').data('unit')  || '';
    const stock = $(this).find(':selected').data('stock') || '';
    $tr.find('.gs-unit').val(unit);
    $tr.find('.gs-stock').val(stock);
  });

  // Add new row
  $('#addRow').on('click', function(){
    const i = row;
    const tpl = `
      <tr class="gs-tr">
        <td class="text-center">${i+1}</td>
        <td>
          <select name="items[${i}][item_id]" class="gs-inp gs-item" required>
            <option value="">select</option>
            @foreach($items as $it)
              <option value="{{ $it->id }}" data-unit="{{ $it->unit_name ?? '' }}" data-stock="{{ number_format($it->stock ?? 0, 2, '.', '') }}">
                {{ $it->name }}
              </option>
            @endforeach
          </select>
        </td>
        <td><input type="text" class="gs-inp gs-read gs-unit" placeholder="Unit" readonly></td>
        <td><input type="text" class="gs-inp gs-read gs-stock" placeholder="Stock" readonly></td>
        <td><input type="number" step="0.01" min="0" name="items[${i}][qty]"  class="gs-inp gs-qty"  placeholder="Quantity"></td>
        <td><input type="number" step="0.01" min="0" name="items[${i}][rate]" class="gs-inp gs-rate" placeholder="Rate"></td>
        <td>
          <select name="items[${i}][adjust_type]" class="gs-inp">
            <option value="OUT">Out</option>
            <option value="IN">In</option>
          </select>
        </td>
        <td class="text-center">
          <button type="button" class="btn btn-sm btn-danger gs-remove"><i class="fas fa-times"></i></button>
        </td>
      </tr>`;
    $('#gsRows').append(tpl);
    row++; renumber();
  });

  // Remove row
  $(document).on('click', '.gs-remove', function(){
    const $rows = $('#gsRows .gs-tr');
    if ($rows.length <= 1) return alert('At least one row is required');
    $(this).closest('tr').remove();
    renumber();
  });

})(jQuery);
</script>
@endpush
