﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Finish Product Adjustment List</span>
      </div>
      <a href="{{ route('adjustment.finish_product.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i><span>Add Finish Product Adjustment</span>
      </a>
    </div>

    <div class="sx-body">

      {{-- FILTERS --}}
      <form method="GET" class="sx-filter">
        <div class="sx-filter-grid">
          <div class="sx-filter-col">
            <div class="sx-filter-title">Company</div>
            <select name="company_id" class="sx-input">
              <option value="">-Company Name-</option>
              @foreach(($companies ?? []) as $c)
                <option value="{{ $c->id }}" {{ request('company_id')==$c->id?'selected':'' }}>
                  {{ $c->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="sx-filter-col">
            <div class="sx-filter-title">Warehouse</div>
            <select name="warehouse_id" class="sx-input">
              <option value="">-Warehouse Name-</option>
              @foreach(($warehouses ?? []) as $w)
                <option value="{{ $w->id }}" {{ request('warehouse_id')==$w->id?'selected':'' }}>
                  {{ $w->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div class="sx-filter-col">
            <div class="sx-filter-title">Filter by Date</div>
            <div class="sx-date-range">
              <div class="sx-dategrp">
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
                <input type="date" name="from" value="{{ request('from') }}" class="sx-input sx-date">
              </div>
              <div class="sx-date-sep"><i class="fas fa-exchange-alt"></i></div>
              <div class="sx-dategrp">
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
                <input type="date" name="to" value="{{ request('to') }}" class="sx-input sx-date">
              </div>
            </div>
          </div>

          <div class="sx-filter-col sx-filter-actions">
            <div class="sx-filter-title">Action</div>
            <div class="d-flex gap-2">
              <button class="btn btn-primary btn-sm">
                <i class="fas fa-search me-1"></i>Search
              </button>
              <a href="{{ route('adjustment.finish_product.index') }}" class="btn btn-light btn-sm">
                <i class="fas fa-sync-alt me-1"></i>Reset
              </a>
            </div>
          </div>
        </div>
      </form>

      {{-- LIST TABLE --}}
      <div class="table-responsive">
        <table class="table sx-table sx-table-list">
          <colgroup>
            <col style="width:70px">
            <col>
            <col style="width:180px">
            <col style="width:220px">
            <col style="width:180px">
            <col style="width:160px">
          </colgroup>

          <thead>
            <tr>
              <th>SL</th>
              <th>Company</th>
              <th>Date</th>
              <th>Warehouse</th>
              <th>Total Adjust Qty</th>
              <th class="text-center">Action</th>
            </tr>
          </thead>

          <tbody>
            @forelse($adjustments as $i => $adj)
              <tr>
                <td>{{ $adjustments->firstItem() + $i }}</td>
                <td>{{ $adj->company->name ?? '-' }}</td>
                <td>{{ optional($adj->date)->format('Y-m-d') ?? '-' }}</td>
                <td>{{ $adj->warehouse->name ?? '-' }}</td>
                <td>{{ number_format($adj->total_qty, 0) }}</td>
                <td class="text-center sx-actions">
                  <a href="{{ route('adjustment.finish_product.show', $adj->id) }}" class="sx-btn sx-btn-view" title="View">
                    <i class="fas fa-eye"></i>
                  </a>
                  <a href="{{ route('adjustment.finish_product.show', $adj->id) }}?print=1" target="_blank" class="sx-btn sx-btn-print" title="Print">
                    <i class="fas fa-print"></i>
                  </a>
                  <a href="{{ route('adjustment.finish_product.edit', $adj->id) }}" class="sx-btn sx-btn-edit" title="Edit">
                    <i class="fas fa-edit"></i>
                  </a>
                  <form action="{{ route('adjustment.finish_product.destroy', $adj->id) }}" method="POST" class="d-inline" onsubmit="return confirm('Delete this adjustment?');">
                    @csrf @method('DELETE')
                    <button type="submit" class="sx-btn sx-btn-del" title="Delete">
                      <i class="fas fa-trash-alt"></i>
                    </button>
                  </form>
                </td>
              </tr>
            @empty
              <tr>
                <td colspan="6" class="text-center text-muted py-4">No data found!</td>
              </tr>
            @endforelse
          </tbody>
        </table>
      </div>

      {{-- pagination --}}
      @if(method_exists($adjustments, 'links'))
        <div class="mt-2">
          {{ $adjustments->withQueryString()->links() }}
        </div>
      @endif
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); background:#fff; border-radius:3px;}
.sx-head{display:flex; align-items:center; justify-content:space-between; background:var(--sx-blue-100); border-bottom:1px solid var(--sx-gray-250); padding:10px 12px;}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title); font-weight:600; font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; background:var(--sx-blue-200); border:1px solid var(--sx-blue-300); color:#2f6fa8; text-decoration:none; border-radius:3px; padding:6px 10px; font-weight:600;}
.sx-body{padding:12px;}

.sx-input{width:100%; height:36px; line-height:36px; padding:4px 10px; border:1px solid #cfd8e3; border-radius:3px; background:#fff;}
.sx-input:focus{outline:0; border-color:#bcc7d6;}

.sx-filter{margin-bottom:10px;}
.sx-filter-grid{display:grid; grid-template-columns: 1.2fr 1.2fr 1.9fr 0.9fr; gap:8px;}
.sx-filter-title{background:#d7e5ff; border:1px solid #c8d8f5; color:#334; font-weight:600; border-radius:3px 3px 0 0; padding:6px 8px;}
.sx-filter-col{display:flex; flex-direction:column;}
.sx-filter-col .sx-input{border-top-left-radius:0; border-top-right-radius:0;}

.sx-date-range{display:flex; align-items:center; gap:6px;}
.sx-dategrp{display:flex; align-items:center; width:100%;}
.sx-date{border-left:0;}
.sx-datebtn{display:inline-flex; align-items:center; justify-content:center; width:36px; height:36px; border:1px solid #cfd8e3; background:#eef2f7; color:#6d7e90; border-right:0; border-radius:3px 0 0 3px;}
.sx-date-sep{padding:0 6px; color:#718097;}

.sx-table{width:100%; border:1px solid var(--sx-gray-250); table-layout:fixed; margin:0;}
.sx-table-list thead th{background:#d7e5ff; color:#223; font-weight:600; padding:8px 10px; border-bottom:1px solid var(--sx-gray-200);}
.sx-table tbody td{padding:10px; vertical-align:middle; border-top:1px solid var(--sx-gray-220);}

.sx-actions .sx-btn{display:inline-flex; align-items:center; justify-content:center; width:30px; height:30px; border-radius:4px; margin:0 2px; border:0; text-decoration:none; color:#fff;}
.sx-btn-view {background:#3bb273;}
.sx-btn-print{background:#3aa5f3;}
.sx-btn-edit {background:#f3a23a;}
.sx-btn-del  {background:#e2574c;}
.sx-btn i{font-size:14px;}
.sx-btn[type="submit"]{cursor:pointer;}

@media (max-width:1200px){
  .sx-filter-grid{grid-template-columns: 1fr 1fr;}
}
</style>
@endpush

