﻿@extends('layouts.app')

@section('content')
<div class="container-fluid">

  <div class="sx-wrap">
    {{-- Header --}}
    <div class="sx-head">
      <div class="sx-head-left">
        <i class="fas fa-list sx-head-ico"></i>
        <span class="sx-head-title">Finish Bag Adjustment List</span>
      </div>

      <a href="{{ route('adjustment.finish_bag.create') }}" class="sx-head-link">
        <i class="fas fa-plus"></i>
        <span>Add Finish Bag Adjustment</span>
      </a>
    </div>

    <div class="sx-body">
      {{-- Filter bar --}}
      <form class="sx-filter" method="GET" action="{{ route('adjustment.finish_bag.index') }}">
        <div class="sx-filter-grid">
          <div>
            <div class="sx-filter-hd">Company</div>
            <select name="company_id" class="sx-input">
              <option value="">-Company Name-</option>
              @foreach($companies as $c)
                <option value="{{ $c->id }}" {{ request('company_id')==$c->id?'selected':'' }}>
                  {{ $c->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div>
            <div class="sx-filter-hd">Warehouse</div>
            <select name="warehouse_id" class="sx-input">
              <option value="">-Warehouse Name-</option>
              @foreach($warehouses as $w)
                <option value="{{ $w->id }}" {{ request('warehouse_id')==$w->id?'selected':'' }}>
                  {{ $w->name }}
                </option>
              @endforeach
            </select>
          </div>

          <div>
            <div class="sx-filter-hd">Filter by Date</div>
            <div class="sx-daterow">
              <div class="sx-dategrp">
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
                <input type="date" name="from" value="{{ request('from') }}" class="sx-input sx-date">
              </div>
              <div class="sx-dategap"><i class="fas fa-exchange-alt"></i></div>
              <div class="sx-dategrp">
                <span class="sx-datebtn"><i class="far fa-calendar"></i></span>
                <input type="date" name="to" value="{{ request('to') }}" class="sx-input sx-date">
              </div>
            </div>
          </div>

          <div class="sx-filter-action">
            <button type="submit" class="sx-search">
              <i class="fas fa-search"></i> Search
            </button>
            <a href="{{ route('adjustment.finish_bag.index') }}" class="sx-reset" title="Reset">
              <i class="fas fa-sync-alt"></i>
            </a>
          </div>
        </div>
      </form>

      {{-- Table --}}
      <div class="table-responsive mt-2">
        <table class="table sx-table">
          <colgroup>
            <col style="width:90px">
            <col>
            <col style="width:160px">
            <col>
            <col style="width:180px">
            <col style="width:170px">
          </colgroup>

        <thead>
          <tr>
            <th>SL</th>
            <th>Company</th>
            <th>Date</th>
            <th>Warehouse</th>
            <th>Total Adjust Qty</th>
            <th class="text-center">Action</th>
          </tr>
        </thead>

        <tbody>
          @forelse($adjustments as $i => $row)
            <tr>
              <td>{{ $adjustments->firstItem() ? ($adjustments->firstItem() + $i) : ($i+1) }}</td>
              <td>{{ $row->company->name ?? '-' }}</td>
              <td>{{ \Illuminate\Support\Carbon::parse($row->date)->format('Y-m-d') }}</td>
              <td>{{ $row->warehouse->name ?? '-' }}</td>
              <td>{{ number_format($row->total_qty, 2) }}</td>
              <td class="text-center sx-actions">
                <a href="{{ route('adjustment.finish_bag.show', $row->id) }}" class="sx-btn sx-btn-view" title="View">
                  <i class="fas fa-eye"></i>
                </a>
                <a href="{{ route('adjustment.finish_bag.edit', $row->id) }}" class="sx-btn sx-btn-edit" title="Edit">
                  <i class="fas fa-edit"></i>
                </a>
                <form action="{{ route('adjustment.finish_bag.destroy', $row->id) }}" method="POST" class="d-inline"
                      onsubmit="return confirm('Delete this adjustment?');">
                  @csrf @method('DELETE')
                  <button type="submit" class="sx-btn sx-btn-del" title="Delete">
                    <i class="fas fa-trash-alt"></i>
                  </button>
                </form>
              </td>
            </tr>
          @empty
            <tr>
              <td colspan="6" class="text-center text-danger py-4">No data found!</td>
            </tr>
          @endforelse
        </tbody>
        </table>
      </div>

      {{-- Pagination --}}
      @if(method_exists($adjustments, 'links'))
        <div class="mt-2">
          {{ $adjustments->withQueryString()->links() }}
        </div>
      @endif
    </div>
  </div>

</div>
@endsection

@push('styles')
<style>
:root{
  --sx-blue-100:#f3f7fb; --sx-blue-200:#eaf2fb; --sx-blue-300:#cfe0f7;
  --sx-gray-120:#eff3f7; --sx-gray-200:#e6ebf1; --sx-gray-220:#edf1f6; --sx-gray-250:#dfe5ec;
  --sx-text:#5d6b7a; --sx-title:#3f4d67;
}
.sx-wrap{border:1px solid var(--sx-gray-250); background:#fff; border-radius:3px;}
.sx-head{display:flex; align-items:center; justify-content:space-between; background:var(--sx-blue-100); border-bottom:1px solid var(--sx-gray-250); padding:10px 12px;}
.sx-head-left{display:flex; gap:8px; align-items:center;}
.sx-head-ico{color:#6aa3c6;}
.sx-head-title{color:var(--sx-title); font-weight:600; font-size:18px;}
.sx-head-link{display:inline-flex; align-items:center; gap:8px; background:var(--sx-blue-200); border:1px solid var(--sx-blue-300);
  color:#2f6fa8; text-decoration:none; border-radius:3px; padding:6px 10px; font-weight:600;}
.sx-body{padding:12px;}

.sx-filter{border:1px solid var(--sx-gray-250); background:#f9fbff;}
.sx-filter-grid{
  display:grid; grid-template-columns:1fr 1fr 1.6fr 220px; gap:10px; padding:10px;
}
.sx-filter-hd{background:#d7e5ff; color:#223; font-weight:600; padding:6px 8px; border:1px solid var(--sx-gray-200);}
.sx-input{width:100%; height:36px; padding:4px 10px; border:1px solid #cfd8e3; border-radius:3px;}
.sx-daterow{display:flex; align-items:center; gap:8px;}
.sx-dategrp{display:flex; align-items:center;}
.sx-date{border-left:0;}
.sx-datebtn{display:inline-flex; align-items:center; justify-content:center; width:36px; height:36px; background:#e6ebf1; border:1px solid #cfd8e3; border-right:0; color:#6d7e90;}
.sx-dategap{color:#6d7e90;}
.sx-filter-action{display:flex; align-items:end; gap:8px; justify-content:flex-start;}
.sx-search{background:#3a86d1; color:#fff; border:0; padding:8px 14px; border-radius:4px; font-weight:600;}
.sx-reset{display:inline-flex; align-items:center; justify-content:center; width:38px; height:36px; background:#e9eef7; border:1px solid #cfd8e3; border-radius:4px; color:#3a86d1;}

.sx-table{width:100%; border:1px solid var(--sx-gray-250); table-layout:fixed; margin-top:8px;}
.sx-table thead th{background:#d7e5ff; color:#223; font-weight:600; padding:8px 10px; border-bottom:1px solid var(--sx-gray-200);}
.sx-table tbody td{padding:10px; vertical-align:middle; border-top:1px solid var(--sx-gray-220);}

.sx-actions .sx-btn{display:inline-flex; align-items:center; justify-content:center; width:30px; height:30px;
  border-radius:4px; margin:0 2px; border:0; text-decoration:none; color:#fff;}
.sx-btn-view {background:#3bb273;}
.sx-btn-edit {background:#f3a23a;}
.sx-btn-del  {background:#e2574c;}
.sx-btn[type="submit"]{cursor:pointer;}
</style>
@endpush