<?php
namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class UserSeeder extends Seeder
{
    public function run(): void
    {
        User::updateOrCreate(
            ['email' => 'admin@example.com'],
            [
                'company_id'           => 1,
                'branch_id'            => null,
                'name'                 => 'System Admin',
                'email_verified_at'    => now(),
                'password'             => Hash::make('12345678'),
                'remember_token'       => Str::random(10),
                'status'               => 1,
                'api_token'            => Str::random(60),
                'password_reset_token' => null,
                'employee_full_id'     => 'EMP-ADMIN',
                'device_token'         => null,
            ]
        );

        User::factory()->count(10)->create();
    }
}

