<?php
namespace Database\Seeders;

use App\Models\User;
use App\Models\Package;
use Illuminate\Database\Seeder;

class SuperAdminSeeder extends Seeder
{
    public function run(): void
    {
        User::firstOrCreate(
            ['email' => 'superadmin@gmail.com'],
            ['name'=>'Super Admin','password'=>bcrypt('12345678'),'is_superadmin'=>true]
        );

        Package::firstOrCreate(
            ['name'=>'Starter'],
            [
                'slug' => 'starter',      // <-- add this line
                'price' => 0,
                'duration_months' => 1,   // or use duration_days if that’s your schema
                'features' => ['users'=>3,'warehouses'=>1,'bag_limit'=>1000],
                'is_active' => 1,
            ]
        );
    }
}


