<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('gs_adjustments', function (Blueprint $table) {
            // keep consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED

            // FK columns (FK will be added in next migration after type check)
            $table->unsignedBigInteger('item_id');      // -> items.id (BIGINT or INT; we will align later)
            $table->unsignedBigInteger('adjusted_by')   // -> users.id
                  ->nullable();

            // core fields
            $table->decimal('old_qty',    15, 3)->default(0);
            $table->decimal('actual_qty', 15, 3)->default(0);
            $table->decimal('diff_qty',   15, 3)->default(0);
            $table->string('reason', 255)->nullable();
            $table->timestamp('adjusted_at')->nullable();

            $table->timestamps();

            // helpful indexes
            $table->index(['item_id', 'adjusted_at'], 'gs_adj_item_date_idx');
            $table->index('adjusted_by', 'gs_adj_by_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('gs_adjustments');
    }
};
