<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (!Schema::hasColumn('products', 'status')) {
                // Add without positioning to avoid referencing a non-existent column
                $table->unsignedTinyInteger('status')->default(1)->index();
                // If you *really* want positioning and the 'type' column exists, uncomment:
                // if (Schema::hasColumn('products', 'type')) {
                //     $table->unsignedTinyInteger('status')->default(1)->index()->after('type');
                // }
            }
        });
    }

    public function down(): void
    {
        Schema::table('products', function (Blueprint $table) {
            if (Schema::hasColumn('products', 'status')) {
                $table->dropColumn('status');
            }
        });
    }
};

