<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('subscriptions', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('business_id');
            $t->unsignedBigInteger('package_id');
            $t->date('starts_at');
            $t->date('ends_at');
            $t->boolean('auto_renew')->default(false);
            $t->string('status')->default('active'); // active, expired, canceled
            $t->timestamps();

            $t->foreign('business_id')->references('id')->on('businesses')->cascadeOnDelete();
            $t->foreign('package_id')->references('id')->on('packages')->restrictOnDelete();
            $t->index(['status','ends_at']);
        });

        // OPTIONAL: users টেবিলে সুপারঅ্যাডমিন ফ্ল্যাগ
        if (!Schema::hasColumn('users','is_superadmin')) {
            Schema::table('users', function (Blueprint $t) {
                $t->boolean('is_superadmin')->default(false)->after('password');
            });
        }
    }
    public function down(): void {
        Schema::dropIfExists('subscriptions');
        if (Schema::hasColumn('users','is_superadmin')) {
            Schema::table('users', fn(Blueprint $t) => $t->dropColumn('is_superadmin'));
        }
    }
};
