<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('businesses', function (Blueprint $t) {
            $t->id();
            $t->string('name');
            $t->unsignedBigInteger('owner_id');               // users.id
            $t->string('subdomain')->unique()->nullable();    // optional multi-tenant via subdomain
            $t->string('domain')->unique()->nullable();       // custom domain (optional)
            $t->string('timezone')->default('Asia/Dhaka');
            $t->boolean('is_active')->default(true);
            $t->timestamps();
            $t->softDeletes();

            $t->foreign('owner_id')->references('id')->on('users')->cascadeOnDelete();
        });

        // pivot: many users can belong to a business
        Schema::create('business_user', function (Blueprint $t) {
            $t->id();
            $t->unsignedBigInteger('business_id');
            $t->unsignedBigInteger('user_id');
            $t->string('role')->default('owner'); // owner, admin, staff
            $t->timestamps();

            $t->unique(['business_id','user_id']);
            $t->foreign('business_id')->references('id')->on('businesses')->cascadeOnDelete();
            $t->foreign('user_id')->references('id')->on('users')->cascadeOnDelete();
        });
    }
    public function down(): void {
        Schema::dropIfExists('business_user');
        Schema::dropIfExists('businesses');
    }
};

