<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('dayars', function (Blueprint $table) {
            if (!Schema::hasColumn('dayars', 'deleted_at')) {
                $table->softDeletes(); // adds nullable TIMESTAMP `deleted_at`
            }
        });
    }

    public function down(): void
    {
        Schema::table('dayars', function (Blueprint $table) {
            if (Schema::hasColumn('dayars', 'deleted_at')) {
                $table->dropSoftDeletes();
            }
        });
    }
};

