<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('supplier_staging', function (Blueprint $t) {
            $t->engine = 'InnoDB';

            $t->id();

            // CSV columns (আপনার Blade/Controller অনুযায়ী)
            $t->string('supplier_name')->nullable();
            $t->string('company_name')->nullable();
            $t->string('email')->nullable();
            $t->string('address')->nullable();
            $t->string('phone_personal')->nullable();

            $t->decimal('opening_balance', 10, 2)->nullable();
            $t->decimal('due_limit', 10, 2)->nullable();

            $t->string('remark')->nullable();

            // mapping hints (string রাখলাম; পরে FK-তে ম্যাপ করলে আলাদা কলাম রাখতে পারেন)
            $t->string('party_type')->nullable();
            $t->string('bag_warehouse')->nullable();

            $t->integer('bag_opening')->nullable();

            // validation flag (Blade এ is_valid চেক করছেন)
            $t->boolean('is_valid')->default(true);

            $t->timestamps();

            // helpful indexes (optional)
            $t->index('supplier_name');
            $t->index('company_name');
            $t->index('email');
            $t->index('phone_personal');
            $t->index('is_valid');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('supplier_staging');
    }
};

