<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('user_login_statuses', function (Blueprint $table) {
            // FK থাকলে ড্রপ
            try { $table->dropForeign('user_login_statuses_company_id_foreign'); } catch (\Throwable $e) {}

            // nullable করে দিন (change() -> doctrine/dbal প্রয়োজন হতে পারে)
            if (Schema::hasColumn('user_login_statuses', 'company_id')) {
                $table->unsignedBigInteger('company_id')->nullable()->change();
            }

            // FK আবার add: nullOnDelete
            $table->foreign('company_id', 'user_login_statuses_company_id_foreign')
                  ->references('id')->on('companies')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('user_login_statuses', function (Blueprint $table) {
            try { $table->dropForeign('user_login_statuses_company_id_foreign'); } catch (\Throwable $e) {}
            // (ইচ্ছে হলে non-nullable ফিরিয়ে নিন)
        });
    }
};
