<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            // আগেই ইনডেক্স দিয়েছেন; FK না থাকলে যোগ করুন
            if (!self::hasForeign('companies', 'companies_group_id_foreign')) {
                $table->foreign('group_id', 'companies_group_id_foreign')
                    ->references('id')->on('groups')
                    ->cascadeOnUpdate()
                    ->restrictOnDelete();
            }

            if (!self::hasForeign('companies', 'companies_business_type_id_foreign')) {
                $table->foreign('business_type_id', 'companies_business_type_id_foreign')
                    ->references('id')->on('business_types')
                    ->cascadeOnUpdate()
                    ->nullOnDelete(); // nullable কলাম, তাই nullOnDelete নিরাপদ
            }
        });
    }

    public function down(): void
    {
        Schema::table('companies', function (Blueprint $table) {
            try { $table->dropForeign('companies_group_id_foreign'); } catch (\Throwable $e) {}
            try { $table->dropForeign('companies_business_type_id_foreign'); } catch (\Throwable $e) {}
        });
    }

    private static function hasForeign(string $table, string $key): bool
    {
        try {
            return in_array($key,
                array_map(fn($i)=>$i->getName(),
                    Schema::getConnection()->getDoctrineSchemaManager()->listTableForeignKeys($table)
                ), true);
        } catch (\Throwable $e) { return false; }
    }
};

