<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // 1) roles
        if (! Schema::hasTable('roles')) {
            Schema::create('roles', function (Blueprint $table) {
                $table->bigIncrements('id');
                $table->string('name');
                $table->string('guard_name')->default('web');
                $table->timestamps();

                $table->unique(['name', 'guard_name']);
            });
        }

        // 2) role_has_permissions
        if (! Schema::hasTable('role_has_permissions')) {
            Schema::create('role_has_permissions', function (Blueprint $table) {
                $table->unsignedBigInteger('permission_id');
                $table->unsignedBigInteger('role_id');

                $table->primary(['permission_id', 'role_id'], 'role_has_permissions_primary');

                // যদি FK নিয়ে সমস্যা হয়, নিচের দুই FK কমেন্ট করে প্রথমে রান করতে পারেন
                $table->foreign('permission_id')->references('id')->on('permissions')->onDelete('cascade');
                $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');
            });
        }

        // 3) model_has_roles
        if (! Schema::hasTable('model_has_roles')) {
            Schema::create('model_has_roles', function (Blueprint $table) {
                $table->unsignedBigInteger('role_id');
                $table->string('model_type');
                $table->unsignedBigInteger('model_id');

                $table->index(['model_id', 'model_type'], 'model_has_roles_model_id_model_type_index');

                $table->foreign('role_id')->references('id')->on('roles')->onDelete('cascade');

                $table->primary(['role_id', 'model_id', 'model_type'], 'model_has_roles_primary');
            });
        }

        // 4) model_has_permissions
        if (! Schema::hasTable('model_has_permissions')) {
            Schema::create('model_has_permissions', function (Blueprint $table) {
                $table->unsignedBigInteger('permission_id');
                $table->string('model_type');
                $table->unsignedBigInteger('model_id');

                $table->index(['model_id', 'model_type'], 'model_has_permissions_model_id_model_type_index');

                $table->foreign('permission_id')->references('id')->on('permissions')->onDelete('cascade');

                $table->primary(['permission_id', 'model_id', 'model_type'], 'model_has_permissions_primary');
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('model_has_permissions')) Schema::drop('model_has_permissions');
        if (Schema::hasTable('model_has_roles')) Schema::drop('model_has_roles');
        if (Schema::hasTable('role_has_permissions')) Schema::drop('role_has_permissions');
        if (Schema::hasTable('roles')) Schema::drop('roles');
    }
};
