<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('branches', function (Blueprint $table) {
            $table->id();

            // Parent company (required)
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            // Branch fields
            $table->string('name', 191);

            // Optional extras you can uncomment if needed:
            // $table->string('email', 191)->nullable();
            // $table->string('phone', 50)->nullable();
            // $table->string('address', 191)->nullable();
            // $table->tinyInteger('status')->default(1); // active/inactive

            $table->timestamps(); // created_at, updated_at
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('branches');
    }
};
