<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('voucher_details', function (Blueprint $table) {
            // Ensure InnoDB (FKs require it)
            $table->engine = 'InnoDB';

            $table->id();

            // Required FKs
            $table->foreignId('voucher_id')
                  ->constrained('vouchers')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('account_id')
                  ->constrained('accounts')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->string('transaction_no', 191)->nullable();
            $table->enum('balance_type', ['Debit', 'Credit']);
            $table->decimal('amount', 15, 2)->default(0.00);

            // --- EITHER A) BIGINT UNSIGNED ids (most Laravel 8/9/10+ setups) ---
            // $table->foreignId('supplier_id')->nullable()
            //       ->constrained('suppliers')->cascadeOnUpdate()->nullOnDelete();
            // $table->foreignId('customer_id')->nullable()
            //       ->constrained('customers')->cascadeOnUpdate()->nullOnDelete();

            // --- OR B) INT UNSIGNED ids (older tables using increments()) ---
            // $table->unsignedInteger('supplier_id')->nullable();
            // $table->unsignedInteger('customer_id')->nullable();
            // $table->foreign('supplier_id')->references('id')->on('suppliers')
            //       ->onUpdate('cascade')->onDelete('set null');
            // $table->foreign('customer_id')->references('id')->on('customers')
            //       ->onUpdate('cascade')->onDelete('set null');

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('voucher_details');
    }
};


