<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('vouchers', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI PK

            $table->string('invoice_no', 191)->nullable();
            $table->string('description', 191);        // NOT NULL
            $table->decimal('amount', 15, 2);          // NOT NULL
            $table->date('date');                      // NOT NULL
            $table->string('reference', 191)->nullable();
            $table->string('voucher_type', 191);       // NOT NULL
            $table->string('attachment', 191)->nullable();
            $table->tinyInteger('is_approved')->default(0); // NOT NULL DEFAULT 0

            // Foreign keys
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            // Timestamps nullable to mirror your dump
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('vouchers');
    }
};
