<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('user_login_statuses', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI PK

            // report-friendly date (e.g. '2025-10-05')
            $table->string('date', 10)->index();

            // required FKs
            $table->foreignId('user_id')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            // login session details (optional but very useful)
            $table->string('session_id', 120)->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->string('user_agent', 255)->nullable();

            // timestamps describing the login window
            $table->timestamp('logged_in_at')->nullable()->index();
            $table->timestamp('logged_out_at')->nullable()->index();

            // keep them nullable to mirror your dump style
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // helpful composite index for reports
            $table->index(['user_id', 'company_id', 'date'], 'uls_user_company_date_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_login_statuses');
    }
};
