<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('user_credentials', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI PK

            // Required FK to users
            $table->foreignId('user_id')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->cascadeOnDelete(); // delete creds if user is deleted

            // Note: keeping the exact column name 'secrete' per your schema
            $table->string('secrete', 191)->nullable();

            // Timestamps nullable to mirror your dump
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('user_credentials');
    }
};

