<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('task_notifications', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI PK

            // Polymorphic target (match given types exactly)
            $table->string('taskable_type', 191);
            $table->integer('taskable_id'); // INT(11) signed to match your dump
            $table->index(['taskable_type', 'taskable_id'], 'task_notifications_taskable_index');

            // Other required fields
            $table->string('route_name', 191);
            $table->string('slug', 191);

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('task_notifications');
    }
};

