<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('supplier_uploads', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI PK

            $table->string('name', 191);
            $table->string('company_name', 191)->nullable();
            $table->string('personal_phone', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('address', 191)->nullable();
            $table->string('party_type', 191)->nullable();

            $table->decimal('opening_balance', 10, 2)->nullable();
            $table->decimal('due_limit', 10, 2)->nullable();

            $table->string('remarks', 191)->nullable();
            $table->string('bag_warehouse', 191)->nullable();
            $table->decimal('bag_opening', 8, 2)->nullable();

            // status: nullable with default 1
            $table->tinyInteger('status')->nullable()->default(1);

            // Foreign keys (indexed)
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // Not nullable

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete(); // Nullable

            $table->timestamps(); // created_at, updated_at (nullable by default)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('supplier_uploads');
    }
};

