<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('supplier_types', function (Blueprint $table) {
            $table->id();                 // BIGINT UNSIGNED AUTO_INCREMENT
            $table->string('name', 191);  // Collation follows DB/connection setting
            $table->timestamps();         // created_at, updated_at (nullable by default)
            // $table->unique('name');     // <- optional uniqueness constraint
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('supplier_types');
    }
};

